/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.template.parser.DataListener;

public class PropertiesSheetListener
implements DataListener {
    private static final String EMPTY_STRING = "";
    private final Map<Integer, String[]> _rowProperties = new HashMap<Integer, String[]>();
    private final Properties _properties = new CaseInsensitiveMap();

    public Properties getProperties() {
        this.finishSheet();
        return this._properties;
    }

    public void startSheet(String name) {
    }

    public void finishSheet() {
        for (String[] keyValue : this._rowProperties.values()) {
            this._properties.put(keyValue[0], keyValue[1]);
        }
    }

    public void newRow(int rowNumber, int columns) {
    }

    public void newCell(int row, int column, String value, int mergedColStart) {
        if (this.emptyCellValue(value)) {
            return;
        }
        Integer rowInt = new Integer(row);
        if (this._rowProperties.containsKey(rowInt)) {
            String[] keyValue = this._rowProperties.get(rowInt);
            if (keyValue[1] == EMPTY_STRING) {
                keyValue[1] = value;
            }
        } else {
            String[] keyValue = new String[]{value, EMPTY_STRING};
            this._rowProperties.put(rowInt, keyValue);
        }
    }

    private boolean emptyCellValue(String value) {
        return value == null || value.trim().equals(EMPTY_STRING);
    }

    public static class CaseInsensitiveMap
    extends Properties {
        public String getProperty(String key) {
            if (this.containsKey(key)) {
                return super.getProperty(key);
            }
            return this.get(key);
        }

        public String getProperty(String key, String defaultValue) {
            String r = this.getProperty(key);
            return r != null ? r : defaultValue;
        }

        private String get(String key) {
            Enumeration<?> keyNames = this.propertyNames();
            while (keyNames.hasMoreElements()) {
                String k = (String)keyNames.nextElement();
                if (!key.equalsIgnoreCase(k)) continue;
                return super.getProperty(k);
            }
            return null;
        }
    }
}

