/*
 * Decompiled with CFR 0.152.
 */
package org.drools.management;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.drools.WorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.RuleFlowCompletedEvent;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.RuleFlowNodeTriggeredEvent;
import org.drools.event.RuleFlowStartedEvent;
import org.drools.management.DroolsManagementAgent;
import org.drools.management.KnowledgeSessionMonitoringMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeSessionMonitoring
implements KnowledgeSessionMonitoringMBean {
    private static final String KSESSION_PREFIX = "org.drools.kbases";
    private static final long NANO_TO_MILLISEC = 1000000L;
    private InternalWorkingMemory ksession;
    private InternalRuleBase kbase;
    private ObjectName name;
    public AgendaStats agendaStats;
    public ProcessStats processStats;

    public KnowledgeSessionMonitoring(InternalWorkingMemory ksession) {
        this.ksession = ksession;
        this.kbase = (InternalRuleBase)ksession.getRuleBase();
        this.name = DroolsManagementAgent.createObjectName("org.drools.kbases:type=" + this.kbase.getId() + ",group=Sessions,sessionId=Session-" + ksession.getId());
        this.agendaStats = new AgendaStats();
        this.processStats = new ProcessStats();
        this.ksession.addEventListener(this.agendaStats);
        this.ksession.addEventListener(this.processStats);
    }

    public void dispose() {
        this.ksession.removeEventListener(this.agendaStats);
        this.ksession.removeEventListener(this.processStats);
    }

    @Override
    public void reset() {
        this.agendaStats.reset();
        this.processStats.reset();
    }

    public InternalWorkingMemory getKsession() {
        return this.ksession;
    }

    public InternalRuleBase getKbase() {
        return this.kbase;
    }

    @Override
    public ObjectName getName() {
        return this.name;
    }

    @Override
    public String getKnowledgeBaseId() {
        return this.kbase.getId();
    }

    @Override
    public int getKnowledgeSessionId() {
        return this.ksession.getId();
    }

    @Override
    public long getTotalFactCount() {
        return this.ksession.getTotalFactCount();
    }

    @Override
    public long getTotalActivationsFired() {
        return this.agendaStats.getConsolidatedStats().activationsFired.get();
    }

    @Override
    public long getTotalActivationsCancelled() {
        return this.agendaStats.getConsolidatedStats().activationsCancelled.get();
    }

    @Override
    public long getTotalActivationsCreated() {
        return this.agendaStats.getConsolidatedStats().activationsCreated.get();
    }

    @Override
    public long getTotalFiringTime() {
        return this.agendaStats.getConsolidatedStats().firingTime.get() / 1000000L;
    }

    @Override
    public Date getLastReset() {
        return this.agendaStats.getConsolidatedStats().lastReset.get();
    }

    @Override
    public double getAverageFiringTime() {
        long fires = this.agendaStats.getConsolidatedStats().activationsFired.get();
        long time = this.agendaStats.getConsolidatedStats().firingTime.get();
        return fires > 0L ? (double)time / (double)fires / 1000000.0 : 0.0;
    }

    @Override
    public String getStatsForRule(String ruleName) {
        AgendaStats.AgendaStatsData data = this.agendaStats.getRuleStats(ruleName);
        String result = data == null ? "activationsCreated=0 activationsCancelled=0 activationsFired=0 firingTime=0ms" : data.toString();
        return result;
    }

    @Override
    public Map<String, String> getStatsByRule() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, AgendaStats.AgendaStatsData> entry : this.agendaStats.getRulesStats().entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @Override
    public long getTotalProcessInstancesStarted() {
        return this.processStats.getConsolidatedStats().processInstancesStarted.get();
    }

    @Override
    public long getTotalProcessInstancesCompleted() {
        return this.processStats.getConsolidatedStats().processInstancesCompleted.get();
    }

    @Override
    public String getStatsForProcess(String processId) {
        ProcessStats.ProcessStatsData data = this.processStats.getProcessStats(processId);
        String result = data == null ? "processInstancesStarted=0 processInstancesCompleted=0 processNodesTriggered=0" : data.toString();
        return result;
    }

    @Override
    public Map<String, String> getStatsByProcess() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ProcessStats.ProcessStatsData> entry : this.processStats.getProcessStats().entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @Override
    public String getStatsForProcessInstance(long processInstanceId) {
        ProcessStats.ProcessInstanceStatsData data = this.processStats.getProcessInstanceStats(processInstanceId);
        String result = data == null ? "Process instance not found" : data.toString();
        return result;
    }

    @Override
    public Map<Long, String> getStatsByProcessInstance() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        for (Map.Entry<Long, ProcessStats.ProcessInstanceStatsData> entry : this.processStats.getProcessInstanceStats().entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessStats
    implements RuleFlowEventListener {
        private GlobalProcessStatsData consolidated = new GlobalProcessStatsData();
        private ConcurrentHashMap<String, ProcessStatsData> processStats = new ConcurrentHashMap();
        private ConcurrentHashMap<Long, ProcessInstanceStatsData> processInstanceStats = new ConcurrentHashMap();

        public GlobalProcessStatsData getConsolidatedStats() {
            return this.consolidated;
        }

        public Map<String, ProcessStatsData> getProcessStats() {
            return this.processStats;
        }

        public ProcessStatsData getProcessStats(String processId) {
            return this.processStats.get(processId);
        }

        public Map<Long, ProcessInstanceStatsData> getProcessInstanceStats() {
            return this.processInstanceStats;
        }

        public ProcessInstanceStatsData getProcessInstanceStats(Long processInstanceId) {
            return this.processInstanceStats.get(processInstanceId);
        }

        public void reset() {
            this.consolidated.reset();
            this.processStats.clear();
            this.processInstanceStats.clear();
        }

        private ProcessStatsData getProcessStatsInstance(String processId) {
            ProcessStatsData data = this.processStats.get(processId);
            if (data == null) {
                data = new ProcessStatsData();
                this.processStats.put(processId, data);
            }
            return data;
        }

        private ProcessInstanceStatsData getProcessInstanceStatsInstance(Long processInstanceId) {
            ProcessInstanceStatsData data = this.processInstanceStats.get(processInstanceId);
            if (data == null) {
                data = new ProcessInstanceStatsData();
                this.processInstanceStats.put(processInstanceId, data);
            }
            return data;
        }

        @Override
        public void afterRuleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
            this.consolidated.processInstancesStarted.incrementAndGet();
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processInstancesStarted.incrementAndGet();
            ProcessInstanceStatsData dataI = this.getProcessInstanceStatsInstance(event.getProcessInstance().getId());
            dataI.processStarted = new Date();
        }

        @Override
        public void afterRuleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
            this.consolidated.processInstancesCompleted.incrementAndGet();
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processInstancesCompleted.incrementAndGet();
            ProcessInstanceStatsData dataI = this.getProcessInstanceStatsInstance(event.getProcessInstance().getId());
            dataI.processCompleted = new Date();
        }

        @Override
        public void afterRuleFlowNodeTriggered(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processNodesTriggered.incrementAndGet();
            ProcessInstanceStatsData dataI = this.getProcessInstanceStatsInstance(event.getProcessInstance().getId());
            ++dataI.processNodesTriggered;
        }

        @Override
        public void afterRuleFlowNodeLeft(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void beforeRuleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void beforeRuleFlowNodeLeft(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void beforeRuleFlowNodeTriggered(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void beforeRuleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
        }

        public static class ProcessInstanceStatsData {
            public Date processStarted;
            public Date processCompleted;
            public long processNodesTriggered = 0L;

            public void reset() {
                this.processNodesTriggered = 0L;
            }

            public String toString() {
                return (this.processStarted != null ? "processStarted=" + this.processStarted + " " : "") + (this.processCompleted != null ? "processCompleted=" + this.processCompleted + " " : "") + "processNodesTriggered=" + this.processNodesTriggered;
            }
        }

        public static class ProcessStatsData
        extends GlobalProcessStatsData {
            public AtomicLong processNodesTriggered = new AtomicLong(0L);

            public void reset() {
                super.reset();
                this.processNodesTriggered.set(0L);
            }

            public String toString() {
                return super.toString() + " processNodesTriggered=" + this.processNodesTriggered.get();
            }
        }

        public static class GlobalProcessStatsData {
            public AtomicLong processInstancesStarted = new AtomicLong(0L);
            public AtomicLong processInstancesCompleted = new AtomicLong(0L);
            public AtomicReference<Date> lastReset = new AtomicReference<Date>(new Date());

            public void reset() {
                this.processInstancesStarted.set(0L);
                this.processInstancesCompleted.set(0L);
                this.lastReset.set(new Date());
            }

            public String toString() {
                return "processInstancesStarted=" + this.processInstancesStarted.get() + " processInstancesCompleted=" + this.processInstancesCompleted.get();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AgendaStats
    implements AgendaEventListener {
        private AgendaStatsData consolidated = new AgendaStatsData();
        private ConcurrentHashMap<String, AgendaStatsData> ruleStats = new ConcurrentHashMap();

        public AgendaStatsData getConsolidatedStats() {
            return this.consolidated;
        }

        public Map<String, AgendaStatsData> getRulesStats() {
            return this.ruleStats;
        }

        public AgendaStatsData getRuleStats(String ruleName) {
            return this.ruleStats.get(ruleName);
        }

        public void reset() {
            this.consolidated.reset();
            this.ruleStats.clear();
        }

        @Override
        public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
            this.consolidated.activationsCancelled.incrementAndGet();
            AgendaStatsData data = this.getRuleStatsInstance(event.getActivation().getRule().getName());
            data.activationsCancelled.incrementAndGet();
        }

        @Override
        public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
            this.consolidated.activationsCreated.incrementAndGet();
            AgendaStatsData data = this.getRuleStatsInstance(event.getActivation().getRule().getName());
            data.activationsCreated.incrementAndGet();
        }

        @Override
        public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
            AgendaStatsData data = this.getRuleStatsInstance(event.getActivation().getRule().getName());
            this.consolidated.stopFireClock();
            data.stopFireClock();
            this.consolidated.activationsFired.incrementAndGet();
            data.activationsFired.incrementAndGet();
        }

        @Override
        public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
        }

        @Override
        public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
            AgendaStatsData data = this.getRuleStatsInstance(event.getActivation().getRule().getName());
            this.consolidated.startFireClock();
            data.startFireClock();
        }

        private AgendaStatsData getRuleStatsInstance(String ruleName) {
            AgendaStatsData data = this.ruleStats.get(ruleName);
            if (data == null) {
                data = new AgendaStatsData();
                this.ruleStats.put(ruleName, data);
            }
            return data;
        }

        public static class AgendaStatsData {
            public AtomicLong activationsFired = new AtomicLong(0L);
            public AtomicLong activationsCreated = new AtomicLong(0L);
            public AtomicLong activationsCancelled = new AtomicLong(0L);
            public AtomicLong firingTime = new AtomicLong(0L);
            public AtomicReference<Date> lastReset = new AtomicReference<Date>(new Date());
            public long start;

            public void startFireClock() {
                this.start = System.nanoTime();
            }

            public void stopFireClock() {
                this.firingTime.addAndGet(System.nanoTime() - this.start);
            }

            public void reset() {
                this.activationsFired.set(0L);
                this.activationsCreated.set(0L);
                this.activationsCancelled.set(0L);
                this.firingTime.set(0L);
                this.lastReset.set(new Date());
            }

            public String toString() {
                return "activationsCreated=" + this.activationsCreated.get() + " activationsCancelled=" + this.activationsCancelled.get() + " activationsFired=" + this.activationsFired.get() + " firingTime=" + this.firingTime.get() / 1000000L + "ms";
            }
        }
    }
}

