/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.builder;

import java.util.HashMap;
import java.util.Map;
import org.drools.definition.process.Node;
import org.drools.process.builder.ActionNodeBuilder;
import org.drools.process.builder.EventBasedNodeBuilder;
import org.drools.process.builder.ExtendedNodeBuilder;
import org.drools.process.builder.ProcessNodeBuilder;
import org.drools.process.builder.SplitNodeBuilder;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.CompositeContextNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.FaultNode;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.workflow.core.node.RuleSetNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.StateNode;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.core.node.TimerNode;
import org.drools.workflow.core.node.WorkItemNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessNodeBuilderRegistry {
    private Map<Class<? extends Node>, ProcessNodeBuilder> registry = new HashMap<Class<? extends Node>, ProcessNodeBuilder>();

    public ProcessNodeBuilderRegistry() {
        this.register(StartNode.class, new ExtendedNodeBuilder());
        this.register(EndNode.class, new ExtendedNodeBuilder());
        this.register(MilestoneNode.class, new EventBasedNodeBuilder());
        this.register(RuleSetNode.class, new EventBasedNodeBuilder());
        this.register(SubProcessNode.class, new EventBasedNodeBuilder());
        this.register(HumanTaskNode.class, new EventBasedNodeBuilder());
        this.register(WorkItemNode.class, new EventBasedNodeBuilder());
        this.register(FaultNode.class, new ExtendedNodeBuilder());
        this.register(TimerNode.class, new ExtendedNodeBuilder());
        this.register(ActionNode.class, new ActionNodeBuilder());
        this.register(Split.class, new SplitNodeBuilder());
        this.register(CompositeContextNode.class, new EventBasedNodeBuilder());
        this.register(StateNode.class, new EventBasedNodeBuilder());
    }

    public void register(Class<? extends Node> cls, ProcessNodeBuilder builder) {
        this.registry.put(cls, builder);
    }

    public ProcessNodeBuilder getNodeBuilder(Node node) {
        return this.registry.get(node.getClass());
    }
}

