/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.core.TransientRepository;
import org.drools.repository.JCRRepositoryConfigurator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitRepositoryConfigurator
implements JCRRepositoryConfigurator {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitRepositoryConfigurator.class);

    public Repository getJCRRepository(String repoRootDir) {
        if (repoRootDir == null) {
            return new TransientRepository();
        }
        return new TransientRepository(repoRootDir + "/repository.xml", repoRootDir);
    }

    public void setupRulesRepository(Session session) throws RulesRepositoryException {
        System.out.println("Setting up the repository, registering node types etc.");
        try {
            Node repositoryNode;
            Node packageAreaNode;
            Node root = session.getRootNode();
            Workspace ws = session.getWorkspace();
            boolean registered = RulesRepositoryAdministrator.isNamespaceRegistered(session);
            if (!registered) {
                ws.getNamespaceRegistry().registerNamespace("drools", "http://www.jboss.org/drools-repository/1.0");
                this.registerNodeTypesFromCndFile("/node_type_definitions/tag_node_type.cnd", session);
                this.registerNodeTypesFromCndFile("/node_type_definitions/state_node_type.cnd", session);
                this.registerNodeTypesFromCndFile("/node_type_definitions/versionable_node_type.cnd", session);
                this.registerNodeTypesFromCndFile("/node_type_definitions/versionable_asset_folder_node_type.cnd", session);
                this.registerNodeTypesFromCndFile("/node_type_definitions/rule_node_type.cnd", session);
                this.registerNodeTypesFromCndFile("/node_type_definitions/rulepackage_node_type.cnd", session);
            }
            if (!(packageAreaNode = RulesRepository.addNodeIfNew(repositoryNode = RulesRepository.addNodeIfNew(root, "drools:repository", "nt:folder"), "drools:package_area", "nt:folder")).hasNode("globalArea")) {
                Node globalAreaNode = RulesRepository.addNodeIfNew(packageAreaNode, "globalArea", "drools:packageNodeType");
                globalAreaNode.addNode("assets", "drools:versionableAssetFolder");
                globalAreaNode.setProperty("drools:title", "globalArea");
                globalAreaNode.setProperty("drools:description", "the global area that holds sharable assets");
                globalAreaNode.setProperty("drools:format", "package");
                globalAreaNode.setProperty("drools:creator", session.getUserID());
                Calendar lastModified = Calendar.getInstance();
                globalAreaNode.setProperty("drools:lastModified", lastModified);
            }
            RulesRepository.addNodeIfNew(repositoryNode, "drools:packagesnapshot_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:tag_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:state_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode.getNode("drools:state_area"), "Draft", "drools:stateNodeType");
            session.save();
        }
        catch (Exception e) {
            log.error("Caught Exception", (Throwable)e);
            System.err.println(e.getMessage());
            throw new RulesRepositoryException(e);
        }
    }

    private void registerNodeTypesFromCndFile(String cndFileName, Session session) throws RulesRepositoryException {
        try {
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(cndFileName));
            CndImporter.registerNodeTypes((Reader)in, (Session)session);
        }
        catch (Exception e) {
            log.error("Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }
}

