/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.core.util.ClassUtils;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.AbstractJavaRuleBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.java.parser.JavaBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaInterfacePointsDescr;
import org.drools.rule.builder.dialect.java.parser.JavaModifyBlockDescr;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.PatternExtractor;
import org.mvel2.compiler.ExecutableStatement;

public class JavaConsequenceBuilder
extends AbstractJavaRuleBuilder
implements ConsequenceBuilder {
    private final Pattern lineBreakFinder = Pattern.compile("\\r\\n|\\r|\\n");

    public void build(RuleBuildContext context, String consequenceName) {
        context.getBuildStack().push(context.getRule().getLhs());
        String className = consequenceName + "Consequence";
        RuleDescr ruleDescr = context.getRuleDescr();
        Map<String, Class<?>> variables = context.getDeclarationResolver().getDeclarationClasses(context.getRule());
        Dialect.AnalysisResult analysis = context.getDialect().analyzeBlock(context, ruleDescr, (String)ruleDescr.getConsequence(), new Map[]{variables, context.getPackageBuilder().getGlobals()});
        if (analysis == null) {
            return;
        }
        String fixedConsequence = this.fixBlockDescr(context, (JavaAnalysisResult)analysis, "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName));
        if (fixedConsequence == null) {
            return;
        }
        fixedConsequence = ((JavaDialect)context.getDialect()).getKnowledgeHelperFixer().fix(fixedConsequence);
        List<String>[] usedIdentifiers = analysis.getBoundIdentifiers();
        Declaration[] declarations = new Declaration[usedIdentifiers[0].size()];
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            declarations[i] = context.getDeclarationResolver().getDeclaration(context.getRule(), usedIdentifiers[0].get(i));
        }
        Map<String, Object> map = this.createVariableContext(className, fixedConsequence, context, declarations, null, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]));
        map.put("consequenceName", consequenceName);
        List<Declaration> list = Arrays.asList(context.getRule().getDeclarations());
        Integer[] indexes = new Integer[declarations.length];
        Boolean[] notPatterns = new Boolean[declarations.length];
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            indexes[i] = new Integer(list.indexOf(declarations[i]));
            Boolean bl = notPatterns[i] = declarations[i].getExtractor() instanceof PatternExtractor ? Boolean.FALSE : Boolean.TRUE;
            if (indexes[i] != -1) continue;
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), ruleDescr, null, "Internal Error : Unable to find declaration in list while generating the consequence invoker"));
        }
        map.put("indexes", indexes);
        map.put("notPatterns", notPatterns);
        JavaConsequenceBuilder.generatTemplates("consequenceMethod", "consequenceInvoker", context, className, map, context.getRule(), ruleDescr);
        context.getBuildStack().pop();
    }

    protected String fixBlockDescr(RuleBuildContext context, JavaAnalysisResult analysis, String originalCode) {
        MVELDialect mvel = (MVELDialect)context.getDialect("mvel");
        List<JavaBlockDescr> blocks = analysis.getBlockDescrs();
        Collections.sort(blocks, new Comparator<JavaBlockDescr>(){

            @Override
            public int compare(JavaBlockDescr o1, JavaBlockDescr o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        StringBuilder consequence = new StringBuilder();
        int lastAdded = 0;
        for (JavaBlockDescr block : blocks) {
            consequence.append(originalCode.substring(lastAdded, block.getStart() - 1));
            lastAdded = block.getEnd();
            switch (block.getType()) {
                case MODIFY: {
                    this.rewriteModify(context, originalCode, mvel, consequence, (JavaModifyBlockDescr)block);
                    break;
                }
                case ENTRY: 
                case EXIT: 
                case CHANNEL: {
                    this.rewriteInterfacePoint(context, originalCode, consequence, (JavaInterfacePointsDescr)block);
                }
            }
        }
        consequence.append(originalCode.substring(lastAdded));
        return consequence.toString();
    }

    private void rewriteInterfacePoint(RuleBuildContext context, String originalCode, StringBuilder consequence, JavaInterfacePointsDescr ep) {
        consequence.append("drools.get");
        if (ep.getType() == JavaBlockDescr.BlockType.EXIT) {
            consequence.append("ExitPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.ENTRY) {
            consequence.append("EntryPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.CHANNEL) {
            consequence.append("Channel( ");
        } else {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), ep, "Unable to rewrite code block: " + ep + "\n"));
            return;
        }
        consequence.append(ep.getId());
        consequence.append(" )");
        String originalBlock = originalCode.substring(ep.getStart() - 1, ep.getEnd());
        int end = originalBlock.indexOf("]");
        this.addLineBreaks(consequence, originalBlock.substring(0, end));
    }

    private void rewriteModify(RuleBuildContext context, String originalCode, MVELDialect mvel, StringBuilder consequence, JavaModifyBlockDescr d) {
        Map<String, Class<?>> variables = context.getDeclarationResolver().getDeclarationClasses(context.getRule());
        Dialect.AnalysisResult mvelAnalysis = mvel.analyzeBlock(context, context.getRuleDescr(), mvel.getInterceptors(), d.getModifyExpression(), new Map[]{variables, context.getPackageBuilder().getGlobals()}, null);
        ExecutableStatement expr = (ExecutableStatement)mvel.compile(d.getModifyExpression(), mvelAnalysis, mvel.getInterceptors(), null, null, context);
        Class ret = expr.getKnownEgressType();
        if (ret == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), originalCode, "Unable to determine the resulting type of the expression: " + d.getModifyExpression() + "\n"));
            return;
        }
        if (d.getEnd() <= 0) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), originalCode, "Incorrect syntax for expression: " + d.getModifyExpression() + "\n"));
            return;
        }
        String retString = ClassUtils.canonicalName(ret);
        consequence.append("{ ");
        consequence.append(retString);
        consequence.append(" __obj__ = (");
        consequence.append(retString);
        consequence.append(") ");
        consequence.append(d.getModifyExpression());
        consequence.append("; ");
        String originalBlock = originalCode.substring(d.getStart() - 1, d.getEnd());
        int end = originalBlock.indexOf("{");
        if (end == -1) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Block missing after modify" + d.getModifyExpression() + " ?\n"));
            return;
        }
        this.addLineBreaks(consequence, originalBlock.substring(0, end));
        int start = end + 1;
        for (String exprStr : d.getExpressions()) {
            end = originalBlock.indexOf(exprStr, start);
            this.addLineBreaks(consequence, originalBlock.substring(start, end));
            consequence.append("__obj__.");
            consequence.append(exprStr);
            consequence.append("; ");
            start = end + exprStr.length();
        }
        this.addLineBreaks(consequence, originalBlock.substring(end));
        consequence.append("update( __obj__ ); }");
    }

    private void addLineBreaks(StringBuilder consequence, String chunk) {
        Matcher m = this.lineBreakFinder.matcher(chunk);
        while (m.find()) {
            consequence.append("\n");
        }
    }
}

