/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Generator;
import org.drools.template.parser.Row;
import org.drools.template.parser.RuleTemplate;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGenerator
implements Generator {
    private Map<String, RuleTemplate> ruleTemplates;
    private TemplateRegistry registry = new SimpleTemplateRegistry();
    private List<String> rules = new ArrayList<String>();

    public DefaultGenerator(Map<String, RuleTemplate> t) {
        this.ruleTemplates = t;
    }

    @Override
    public void generate(String templateName, Row row) {
        try {
            CompiledTemplate template = this.getTemplate(templateName);
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("row", row);
            for (Cell cell : row.getCells()) {
                cell.addValue(vars);
            }
            String drl = String.valueOf(TemplateRuntime.execute(template, vars, this.registry));
            this.rules.add(drl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CompiledTemplate getTemplate(String templateName) throws IOException {
        CompiledTemplate contents;
        if (!this.registry.contains(templateName)) {
            RuleTemplate template = this.ruleTemplates.get(templateName);
            contents = TemplateCompiler.compileTemplate(template.getContents());
            this.registry.addNamedTemplate(templateName, contents);
        } else {
            contents = this.registry.getNamedTemplate(templateName);
        }
        return contents;
    }

    @Override
    public String getDrl() {
        StringBuffer sb = new StringBuffer();
        for (String rule : this.rules) {
            sb.append(rule).append("\n");
        }
        return sb.toString();
    }
}

