/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.packaging;

import java.util.ArrayList;
import java.util.List;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.xbean.AbstractXBeanServiceUnitAnalyzer;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.patterns.ContentBasedRouter;
import org.apache.servicemix.eip.patterns.MessageFilter;
import org.apache.servicemix.eip.patterns.Pipeline;
import org.apache.servicemix.eip.patterns.SplitAggregator;
import org.apache.servicemix.eip.patterns.StaticRecipientList;
import org.apache.servicemix.eip.patterns.StaticRoutingSlip;
import org.apache.servicemix.eip.patterns.WireTap;
import org.apache.servicemix.eip.patterns.XPathSplitter;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.eip.support.RoutingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EipServiceUnitAnalyzer
extends AbstractXBeanServiceUnitAnalyzer {
    protected List<Consumes> getConsumes(Endpoint endpoint) {
        List<Consumes> consumes = endpoint instanceof ContentBasedRouter ? this.resolveContentBasedRouter((ContentBasedRouter)endpoint) : (endpoint instanceof MessageFilter ? this.resolveMessageFilter((MessageFilter)endpoint) : (endpoint instanceof Pipeline ? this.resolvePipeline((Pipeline)endpoint) : (endpoint instanceof SplitAggregator ? this.resolveSplitAggregator((SplitAggregator)endpoint) : (endpoint instanceof StaticRecipientList ? this.resolveStaticRecipientList((StaticRecipientList)endpoint) : (endpoint instanceof StaticRoutingSlip ? this.resolveStaticRoutingSlip((StaticRoutingSlip)endpoint) : (endpoint instanceof WireTap ? this.resolveWireTap((WireTap)endpoint) : (endpoint instanceof XPathSplitter ? this.resolveXPathSplitter((XPathSplitter)endpoint) : new ArrayList<Consumes>())))))));
        return consumes;
    }

    private List<Consumes> resolveXPathSplitter(XPathSplitter splitter) {
        return this.generateConsumesFromTarget(splitter.getTarget(), new ArrayList<Consumes>());
    }

    private List<Consumes> resolveWireTap(WireTap tap) {
        List<Consumes> consumes = new ArrayList<Consumes>();
        consumes = this.generateConsumesFromTarget(tap.getTarget(), consumes);
        consumes = this.generateConsumesFromTarget(tap.getInListener(), consumes);
        consumes = this.generateConsumesFromTarget(tap.getOutListener(), consumes);
        consumes = this.generateConsumesFromTarget(tap.getFaultListener(), consumes);
        return consumes;
    }

    private List<Consumes> resolveStaticRoutingSlip(StaticRoutingSlip slip) {
        List<Consumes> consumes = new ArrayList<Consumes>();
        for (int i = 0; i < slip.getTargets().length; ++i) {
            consumes = this.generateConsumesFromTarget(slip.getTargets()[i], consumes);
        }
        return consumes;
    }

    private List<Consumes> resolveStaticRecipientList(StaticRecipientList list) {
        List<Consumes> consumes = new ArrayList<Consumes>();
        for (int i = 0; i < list.getRecipients().length; ++i) {
            consumes = this.generateConsumesFromTarget(list.getRecipients()[i], consumes);
        }
        return consumes;
    }

    private List<Consumes> resolveSplitAggregator(SplitAggregator aggregator) {
        return this.generateConsumesFromTarget(aggregator.getTarget(), new ArrayList<Consumes>());
    }

    private List<Consumes> resolvePipeline(Pipeline pipeline) {
        List<Consumes> consumes = this.generateConsumesFromTarget(pipeline.getTarget(), new ArrayList<Consumes>());
        consumes = this.generateConsumesFromTarget(pipeline.getTransformer(), consumes);
        return consumes;
    }

    private List<Consumes> resolveMessageFilter(MessageFilter filter) {
        return this.generateConsumesFromTarget(filter.getTarget(), new ArrayList<Consumes>());
    }

    private List<Consumes> resolveContentBasedRouter(ContentBasedRouter router) {
        List<Consumes> consumes = new ArrayList<Consumes>();
        for (int i = 0; i < router.getRules().length; ++i) {
            RoutingRule rule = router.getRules()[i];
            consumes = this.generateConsumesFromTarget(rule.getTarget(), consumes);
        }
        return consumes;
    }

    private List<Consumes> generateConsumesFromTarget(ExchangeTarget target, List<Consumes> consumes) {
        if (target != null) {
            Consumes consume = new Consumes();
            consume.setEndpointName(target.getEndpoint());
            consume.setServiceName(target.getService());
            consume.setInterfaceName(target.getInterface());
            consumes.add(consume);
        }
        return consumes;
    }

    protected String getXBeanFile() {
        return "xbean.xml";
    }

    protected boolean isValidEndpoint(Object bean) {
        return bean instanceof EIPEndpoint;
    }
}

