/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.java.MiniJava;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Convert;
import org.jruby.util.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Fixnum"}, parent="Integer", include={"Precision"})
public class RubyFixnum
extends RubyInteger {
    private final long value;
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;
    private static final int CACHE_OFFSET = 128;
    private static final Map<Class, TypeCoercer> JAVA_COERCERS = new HashMap<Class, TypeCoercer>();

    public static RubyClass createFixnumClass(Ruby runtime) {
        RubyClass fixnum = runtime.defineClass("Fixnum", runtime.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFixnum(fixnum);
        fixnum.index = 1;
        fixnum.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyFixnum;
            }
        };
        fixnum.includeModule(runtime.getPrecision());
        fixnum.defineAnnotatedMethods(RubyFixnum.class);
        for (int i = 0; i < runtime.fixnumCache.length; ++i) {
            runtime.fixnumCache[i] = new RubyFixnum(runtime, fixnum, i - 128);
        }
        return fixnum;
    }

    private static IRubyObject fixCoerce(IRubyObject x) {
        while (!((x = x.convertToInteger()) instanceof RubyFixnum) && !(x instanceof RubyBignum)) {
        }
        return x;
    }

    public RubyFixnum(Ruby runtime) {
        this(runtime, 0L);
    }

    public RubyFixnum(Ruby runtime, long value) {
        super(runtime, runtime.getFixnum(), false);
        this.value = value;
    }

    private RubyFixnum(Ruby runtime, RubyClass klazz, long value) {
        super(runtime, klazz, false);
        this.value = value;
    }

    @Override
    public int getNativeTypeIndex() {
        return 1;
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other instanceof RubyFixnum && this.value == ((RubyFixnum)other).value;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum newFixnum(Ruby runtime, long value) {
        if (RubyFixnum.isInCacheRange(value)) {
            return runtime.fixnumCache[(int)value + 128];
        }
        return new RubyFixnum(runtime, value);
    }

    private static boolean isInCacheRange(long value) {
        return value <= 127L && value >= -128L;
    }

    public RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getRuntime(), newValue);
    }

    public static RubyFixnum zero(Ruby runtime) {
        return runtime.fixnumCache[128];
    }

    public static RubyFixnum one(Ruby runtime) {
        return runtime.fixnumCache[129];
    }

    public static RubyFixnum two(Ruby runtime) {
        return runtime.fixnumCache[130];
    }

    public static RubyFixnum three(Ruby runtime) {
        return runtime.fixnumCache[131];
    }

    public static RubyFixnum four(Ruby runtime) {
        return runtime.fixnumCache[132];
    }

    public static RubyFixnum five(Ruby runtime) {
        return runtime.fixnumCache[133];
    }

    public static RubyFixnum minus_one(Ruby runtime) {
        return runtime.fixnumCache[127];
    }

    @Override
    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum num = (RubyFixnum)other;
            if (num.value == this.value) {
                return true;
            }
        }
        return false;
    }

    @JRubyMethod(optional=1)
    public RubyString to_s(IRubyObject[] args) {
        int base;
        int n = base = args.length == 0 ? 10 : RubyFixnum.num2int(args[0]);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return this.getRuntime().newString(Convert.longToByteList(this.value, base));
    }

    @JRubyMethod
    public IRubyObject id2name() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (symbol != null) {
            return this.getRuntime().newString(symbol.asJavaString());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject to_sym() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        return symbol != null ? symbol : this.getRuntime().getNil();
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        if (this.value == Long.MIN_VALUE) {
            return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.addFixnum(context, (RubyFixnum)other);
        }
        return this.addOther(context, other);
    }

    private IRubyObject addFixnum(ThreadContext context, RubyFixnum other) {
        long otherValue = other.value;
        long result = this.value + otherValue;
        if (RubyFixnum.additionOverflowed(this.value, otherValue, result)) {
            return this.addAsBignum(context, other);
        }
        return this.newFixnum(result);
    }

    private static boolean additionOverflowed(long original, long other, long result) {
        return ((original ^ other ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result) & Long.MIN_VALUE) != 0L;
    }

    private static boolean subtractionOverflowed(long original, long other, long result) {
        return ((original ^ (other ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result) & Long.MIN_VALUE) != 0L;
    }

    private IRubyObject addAsBignum(ThreadContext context, RubyFixnum other) {
        return RubyBignum.newBignum(this.getRuntime(), this.value).op_plus(context, other);
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_plus(context, this);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value + ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.subtractFixnum(context, (RubyFixnum)other);
        }
        return this.subtractOther(context, other);
    }

    private IRubyObject subtractFixnum(ThreadContext context, RubyFixnum other) {
        long otherValue = other.value;
        long result = this.value - otherValue;
        if (RubyFixnum.subtractionOverflowed(this.value, otherValue, result)) {
            return this.subtractAsBignum(context, other);
        }
        return this.newFixnum(result);
    }

    private IRubyObject subtractAsBignum(ThreadContext context, RubyFixnum other) {
        return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(context, other);
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(context, other);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value - ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            if (this.value == 0L) {
                return RubyFixnum.zero(this.getRuntime());
            }
            long result = this.value * otherValue;
            RubyFixnum r = RubyFixnum.newFixnum(this.getRuntime(), result);
            if (RubyNumeric.fix2long(r) != result || result / this.value != otherValue) {
                return (RubyNumeric)RubyBignum.newBignum(this.getRuntime(), this.value).op_mul(context, other);
            }
            return r;
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_mul(context, this);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value * ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "*", other);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div_div(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other, "div");
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other, "/");
    }

    @JRubyMethod(name={"odd?"})
    public RubyBoolean odd_p() {
        if (this.value % 2L != 0L) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"even?"})
    public RubyBoolean even_p() {
        if (this.value % 2L == 0L) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod
    public IRubyObject pred() {
        return this.getRuntime().newFixnum(this.value - 1L);
    }

    public IRubyObject idiv(ThreadContext context, IRubyObject other, String method) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            if (y == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long div = x / y;
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div;
            }
            return this.getRuntime().newFixnum(div);
        }
        return this.coerceBin(context, method, other);
    }

    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            if (y == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                mod += y;
            }
            return this.getRuntime().newFixnum(mod);
        }
        return this.coerceBin(context, "%", other);
    }

    @Override
    @JRubyMethod
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            Ruby runtime = this.getRuntime();
            if (y == 0L) {
                throw runtime.newZeroDivisionError();
            }
            long div = x / y;
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div;
                mod += y;
            }
            RubyFixnum fixDiv = RubyFixnum.newFixnum(this.getRuntime(), div);
            RubyFixnum fixMod = RubyFixnum.newFixnum(this.getRuntime(), mod);
            return RubyArray.newArray(runtime, fixDiv, fixMod);
        }
        return this.coerceBin(context, "divmod", other);
    }

    @Override
    @JRubyMethod
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyFloat.newFloat(this.getRuntime(), (double)this.value / (double)((RubyFixnum)other).value);
        }
        return this.coerceBin(context, "quo", other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long b = ((RubyFixnum)other).value;
            if (b == 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            if (b == 1L) {
                return this;
            }
            if (b > 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_pow(context, other);
            }
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, b));
        }
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyFloat)other).getDoubleValue()));
        }
        return this.coerceBin(context, "**", other);
    }

    @JRubyMethod
    public IRubyObject abs() {
        if (this.value < 0L) {
            if (this.value == Long.MIN_VALUE) {
                return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
            }
            return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyFixnum)other).value);
        }
        return super.op_num_equal(context, other);
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.compareFixnum(context, (RubyFixnum)other);
        }
        return this.coerceCmp(context, "<=>", other);
    }

    private IRubyObject compareFixnum(ThreadContext context, RubyFixnum other) {
        long otherValue = other.value;
        if (this.value == otherValue) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (this.value > otherValue) {
            return RubyFixnum.one(this.getRuntime());
        }
        return RubyFixnum.minus_one(this.getRuntime());
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value > ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, ">", other);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value >= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, ">=", other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value < ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, "<", other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value <= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, "<=", other);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return this.newFixnum(this.value & ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_and(context, this);
    }

    @JRubyMethod(name={"|"})
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return this.newFixnum(this.value | ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_or(context, this);
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return this.newFixnum(this.value ^ ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_xor(context, this);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject other) {
        long otherValue;
        if (!(other instanceof RubyFixnum) && !((other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum)) {
            RubyBignum big = (RubyBignum)other;
            RubyInteger tryFix = RubyBignum.bignorm(this.getRuntime(), big.getValue());
            if (!(tryFix instanceof RubyFixnum)) {
                return big.getValue().signum() == 0 || this.value >= 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
            }
        }
        if ((otherValue = RubyFixnum.fix2long(other)) < 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (63L < otherValue) {
            return this.value < 0L ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return (this.value & 1L << (int)otherValue) == 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject op_lshift(IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(other);
        }
        long width = ((RubyFixnum)other).getLongValue();
        return width < 0L ? this.rshift(-width) : this.lshift(width);
    }

    private IRubyObject lshift(long width) {
        if (width > 63L || (-1L << (int)(64L - width - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(RubyFixnum.newFixnum(this.getRuntime(), width));
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value << (int)width);
    }

    @JRubyMethod(name={">>"})
    public IRubyObject op_rshift(IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_rshift(other);
        }
        long width = ((RubyFixnum)other).getLongValue();
        if (width == 0L) {
            return this;
        }
        return width < 0L ? this.lshift(-width) : this.rshift(width);
    }

    private IRubyObject rshift(long width) {
        if (width >= 63L) {
            return this.value < 0L ? RubyFixnum.minus_one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value >> (int)width);
    }

    @JRubyMethod
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value);
    }

    @JRubyMethod
    public IRubyObject size() {
        return this.newFixnum(8L);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0L);
    }

    @Override
    @JRubyMethod
    public IRubyObject id() {
        if (this.value <= 0x3FFFFFFFFFFFFFFFL && this.value >= -4611686018427387904L) {
            return this.newFixnum(2L * this.value + 1L);
        }
        return super.id();
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    @Override
    public String asJavaString() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "do not use Fixnums as Symbols", new Object[0]);
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (symbol == null) {
            throw this.getRuntime().newArgumentError("" + this.value + " is not a symbol");
        }
        return symbol.asJavaString();
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject induced_from(IRubyObject recv, IRubyObject other) {
        return RubyNumeric.num2fix(other);
    }

    @Override
    public IRubyObject to_java() {
        return MiniJava.javaToRuby(this.getRuntime(), this.value);
    }

    @Override
    public IRubyObject as(Class javaClass) {
        return MiniJava.javaToRuby(this.getRuntime(), RubyFixnum.coerceToJavaType(this.getRuntime(), this, javaClass));
    }

    private static Object coerceToJavaType(Ruby ruby, RubyFixnum self, Class javaClass) {
        if (!Number.class.isAssignableFrom(javaClass)) {
            throw ruby.newTypeError(javaClass.getCanonicalName() + " is not a numeric type");
        }
        TypeCoercer coercer = JAVA_COERCERS.get(javaClass);
        if (coercer == null) {
            throw ruby.newTypeError("Cannot coerce Fixnum to " + javaClass.getCanonicalName());
        }
        return coercer.coerce(self);
    }

    static {
        TypeCoercer intCoercer = new TypeCoercer(){

            public Object coerce(IRubyObject self) {
                RubyFixnum fixnum = (RubyFixnum)self;
                if (fixnum.value > Integer.MAX_VALUE) {
                    throw self.getRuntime().newRangeError("Fixnum " + fixnum.value + " is too large for Java int");
                }
                return (int)fixnum.value;
            }
        };
        JAVA_COERCERS.put(Integer.TYPE, intCoercer);
        JAVA_COERCERS.put(Integer.class, intCoercer);
    }
}

