/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignOneArgNode;
import org.jruby.ast.AttrAssignThreeArgNode;
import org.jruby.ast.AttrAssignTwoArgNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    private final Node receiverNode;
    private String name;
    private Node argsNode;
    public CallSite variableCallAdapter;
    public CallSite normalCallAdapter;

    public AttrAssignNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        super(position, NodeType.ATTRASSIGNNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.name = name;
        this.setArgsInternal(argsNode);
        this.normalCallAdapter = MethodIndex.getCallSite(name);
        this.variableCallAdapter = MethodIndex.getVariableCallSite(name);
    }

    @Override
    public Instruction accept(NodeVisitor visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    protected Node newAttrAssignNode(ArrayNode argsNode) {
        int size = argsNode.size();
        switch (size) {
            case 1: {
                return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
            case 2: {
                return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
            case 3: {
                return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, argsNode);
    }

    protected Node newMutatedAttrAssignNode(ArrayNode argsNode) {
        int size = argsNode.size();
        switch (size) {
            case 1: {
                if (!(this instanceof AttrAssignOneArgNode)) {
                    return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
            case 2: {
                if (!(this instanceof AttrAssignTwoArgNode)) {
                    return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
            case 3: {
                if (!(this instanceof AttrAssignThreeArgNode)) {
                    return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, argsNode);
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        if (this.argsNode == null && argsNode instanceof ArrayNode) {
            return this.newAttrAssignNode((ArrayNode)argsNode);
        }
        if (this.argsNode == argsNode) {
            return this.newMutatedAttrAssignNode((ArrayNode)argsNode);
        }
        this.setArgsInternal(argsNode);
        return this;
    }

    private void setArgsInternal(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, args);
        } else {
            this.normalCallAdapter.call(context, receiver, args);
        }
        return args[args.length - 1];
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        CallType callType;
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, block);
        CallType callType2 = callType = receiver == self ? CallType.VARIABLE : CallType.NORMAL;
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(context, receiver, this.name, value, callType, Block.NULL_BLOCK);
        } else {
            RubyArray args = (RubyArray)this.argsNode.interpret(runtime, context, self, block);
            args.append(value);
            RuntimeHelpers.invoke(context, receiver, this.name, args.toJavaArray(), callType, Block.NULL_BLOCK);
        }
        return runtime.getNil();
    }
}

