/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AttrAssignTwoArgNode
extends AttrAssignNode {
    private Node arg1;
    private Node arg2;

    public AttrAssignTwoArgNode(ISourcePosition position, Node receiverNode, String name, ArrayNode argsNode) {
        super(position, receiverNode, name, argsNode);
        assert (argsNode.size() == 2) : "argsNode.size() is 2";
        this.arg1 = argsNode.get(0);
        this.arg2 = argsNode.get(1);
    }

    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.getReceiverNode().interpret(runtime, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime, context, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, param1, param2);
        } else {
            this.normalCallAdapter.call(context, receiver, param1, param2);
        }
        return param2;
    }

    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block aBlock, boolean checkArity) {
        IRubyObject receiver = this.getReceiverNode().interpret(runtime, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime, context, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, param1, param2, value);
        } else {
            this.normalCallAdapter.call(context, receiver, param1, param2, value);
        }
        return runtime.getNil();
    }
}

