/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class CallOneArgBlockNode
extends CallNode {
    private Node arg1;

    public CallOneArgBlockNode(ISourcePosition position, Node receiverNode, String name, ArrayNode args, IterNode iter) {
        super(position, receiverNode, name, args, iter);
        assert (args.size() == 1) : "args.size() is 1";
        this.arg1 = args.get(0);
    }

    /*
     * Loose catch block
     */
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.getReceiverNode().interpret(runtime, context, self, aBlock);
        Block block = this.getBlock(context, self, (IterNode)this.getIterNode());
        while (true) {
            try {
                return this.callAdapter.call(context, receiver, this.arg1.interpret(runtime, context, self, aBlock), block);
            }
            catch (JumpException.RetryJump rj) {
                continue;
            }
            break;
        }
        catch (JumpException.BreakJump bj) {
            return (IRubyObject)bj.getValue();
        }
    }
}

