/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    public FCallNode(ISourcePosition position, String name, Node argsNode) {
        this(position, name, argsNode, null);
    }

    public FCallNode(ISourcePosition position, String name, Node argsNode, Node iterNode) {
        super(position, NodeType.FCALLNODE);
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getFunctionalCallSite(name);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getFunctionalCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        return argsNode;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "FCallNode: " + this.getName();
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.iterNode == null && this.argsNode != null && this.argsNode.nodeId == NodeType.ARRAYNODE) {
            ArrayNode arrayNode = (ArrayNode)this.argsNode;
            switch (arrayNode.size()) {
                case 0: {
                    return this.callAdapter.call(context, self);
                }
                case 1: {
                    IRubyObject arg0 = arrayNode.get(0).interpret(runtime, context, self, aBlock);
                    return this.callAdapter.call(context, self, arg0);
                }
                case 2: {
                    IRubyObject arg0 = arrayNode.get(0).interpret(runtime, context, self, aBlock);
                    IRubyObject arg1 = arrayNode.get(1).interpret(runtime, context, self, aBlock);
                    return this.callAdapter.call(context, self, arg0, arg1);
                }
                case 3: {
                    IRubyObject arg0 = arrayNode.get(0).interpret(runtime, context, self, aBlock);
                    IRubyObject arg1 = arrayNode.get(1).interpret(runtime, context, self, aBlock);
                    IRubyObject arg2 = arrayNode.get(2).interpret(runtime, context, self, aBlock);
                    return this.callAdapter.call(context, self, arg0, arg1, arg2);
                }
            }
        }
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self, aBlock);
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, this.iterNode);
        if (!block.isGiven()) {
            return this.callAdapter.call(context, self, args);
        }
        while (true) {
            try {
                return this.callAdapter.call(context, self, args, block);
            }
            catch (JumpException.RetryJump rj) {
                continue;
            }
            break;
        }
    }

    public Block getBlock(ThreadContext context, IRubyObject self, IterNode iter) {
        assert (iter != null) : "iter is not null";
        iter.getScope().determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iter.getBlockBody(), self);
    }
}

