/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlipNode
extends Node {
    private final Node beginNode;
    private final Node endNode;
    private final boolean exclusive;
    private final int location;

    public FlipNode(ISourcePosition position, Node beginNode, Node endNode, boolean exclusive, int location) {
        super(position, NodeType.FLIPNODE);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = beginNode;
        this.endNode = endNode;
        this.exclusive = exclusive;
        this.location = location;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFlipNode(this);
    }

    public Node getBeginNode() {
        return this.beginNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.beginNode, this.endNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        DynamicScope scope = context.getCurrentScope();
        int index = this.getIndex();
        int depth = this.getDepth();
        DynamicScope nthParent = scope.getNthParentScope(depth);
        if (nthParent != null) {
            nthParent.growIfNeeded();
        }
        IRubyObject result = scope.getValue(index, depth);
        if (this.exclusive) {
            if (result == null || !result.isTrue()) {
                result = this.beginNode.interpret(runtime, context, self, aBlock).isTrue() ? runtime.getTrue() : runtime.getFalse();
                scope.setValue(index, result, depth);
                return result;
            }
            if (this.endNode.interpret(runtime, context, self, aBlock).isTrue()) {
                scope.setValue(index, runtime.getFalse(), depth);
            }
            return runtime.getTrue();
        }
        if (result == null || !result.isTrue()) {
            if (this.beginNode.interpret(runtime, context, self, aBlock).isTrue()) {
                scope.setValue(index, this.endNode.interpret(runtime, context, self, aBlock).isTrue() ? runtime.getFalse() : runtime.getTrue(), depth);
                return runtime.getTrue();
            }
            return runtime.getFalse();
        }
        if (this.endNode.interpret(runtime, context, self, aBlock).isTrue()) {
            scope.setValue(index, runtime.getFalse(), depth);
        }
        return runtime.getTrue();
    }
}

