/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyClass;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class ASTInterpreter {
    public static IRubyObject eval(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        assert (self != null) : "self during eval must never be null";
        if (node == null) {
            return runtime.getNil();
        }
        try {
            return node.interpret(runtime, context, self, block);
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
    }

    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, IRubyObject scope, String file, int lineNumber) {
        assert (!scope.isNil());
        Ruby runtime = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        if (!(scope instanceof RubyBinding)) {
            if (scope instanceof RubyProc) {
                scope = ((RubyProc)scope).binding();
            } else {
                throw runtime.newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
            }
        }
        Binding binding = ((RubyBinding)scope).getBinding();
        DynamicScope evalScope = binding.getDynamicScope().getEvalScope();
        if (file == null) {
            file = binding.getFrame().getFile();
        }
        if (lineNumber == -1) {
            lineNumber = binding.getFrame().getLine();
        }
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding);
        try {
            IRubyObject newSelf = binding.getSelf();
            RubyString source = src.convertToString();
            Node node = runtime.parseEval(source.getByteList(), file, evalScope, lineNumber);
            IRubyObject iRubyObject = ASTInterpreter.eval(runtime, context, node, newSelf, binding.getFrame().getBlock());
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw runtime.newLocalJumpError("break", (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump rj) {
            throw runtime.newLocalJumpError("redo", (IRubyObject)rj.getValue(), "unexpected redo");
        }
        finally {
            context.postEvalWithBinding(binding, lastFrame);
            context.setFile(savedFile);
            context.setLine(savedLine);
        }
    }

    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, IRubyObject src, String file, int lineNumber) {
        RubyString source = src.convertToString();
        return ASTInterpreter.evalSimple(context, self, source, file, lineNumber);
    }

    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, RubyString src, String file, int lineNumber) {
        assert (file != null);
        Ruby runtime = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        RubyString source = src.convertToString();
        DynamicScope evalScope = context.getCurrentScope().getEvalScope();
        evalScope.getStaticScope().determineModule();
        try {
            Node node = runtime.parseEval(source.getByteList(), file, evalScope, lineNumber);
            IRubyObject iRubyObject = ASTInterpreter.eval(runtime, context, node, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw runtime.newLocalJumpError("break", (IRubyObject)bj.getValue(), "unexpected break");
        }
        finally {
            context.setFile(savedFile);
            context.setLine(savedLine);
        }
    }

    public static void callTraceFunction(Ruby runtime, ThreadContext context, int event) {
        String name = context.getFrameName();
        RubyModule type = context.getFrameKlazz();
        runtime.callEventHooks(context, event, context.getFile(), context.getLine(), name, type);
    }

    public static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result) {
        context.pollThreadEvents();
        return result;
    }

    public static IRubyObject multipleAsgnArrayNode(Ruby runtime, ThreadContext context, MultipleAsgnNode iVisited, ArrayNode node, IRubyObject self, Block aBlock) {
        IRubyObject[] array = new IRubyObject[node.size()];
        for (int i = 0; i < node.size(); ++i) {
            array[i] = node.get(i).interpret(runtime, context, self, aBlock);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime, array), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalClassDefinitionBody(Ruby runtime, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type, IRubyObject self, Block block) {
        context.preClassEval(scope, type);
        try {
            if (runtime.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime, context, 1);
            }
            if (bodyNode == null) {
                IRubyObject iRubyObject = runtime.getNil();
                return iRubyObject;
            }
            IRubyObject iRubyObject = bodyNode.interpret(runtime, context, type, block);
            return iRubyObject;
        }
        finally {
            if (runtime.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime, context, 2);
            }
            context.postClassEval();
        }
    }

    private static String getArgumentDefinition(Ruby runtime, ThreadContext context, Node node, String type, IRubyObject self, Block block) {
        if (node == null) {
            return type;
        }
        if (node instanceof ArrayNode) {
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node iterNode = ((ArrayNode)node).get(i);
                if (ASTInterpreter.getDefinitionInner(runtime, context, iterNode, self, block) != null) continue;
                return null;
            }
        } else if (ASTInterpreter.getDefinitionInner(runtime, context, node, self, block) == null) {
            return null;
        }
        return type;
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            IterNode iterNode = (IterNode)blockNode;
            StaticScope scope = iterNode.getScope();
            scope.determineModule();
            return InterpretedBlock.newInterpretedClosure(context, iterNode.getBlockBody(), self);
        }
        if (blockNode instanceof BlockPassNode) {
            Node bodyNode = ((BlockPassNode)blockNode).getBodyNode();
            IRubyObject proc = bodyNode == null ? runtime.getNil() : bodyNode.interpret(runtime, context, self, currentBlock);
            return RuntimeHelpers.getBlockFromBlockPassBody(proc, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime) {
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        if (rubyClass.isSingleton() || rubyClass == runtime.getDummy()) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() == null) {
                runtime.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method", new Object[0]);
            }
        }
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefinition(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String string = ASTInterpreter.getDefinitionInner(runtime, context, node, self, aBlock);
            return string;
        }
        finally {
            context.setWithinDefined(false);
        }
    }

    private static String getDefinitionInner(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return "expression";
        }
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                AttrAssignNode iVisited = (AttrAssignNode)node;
                if (ASTInterpreter.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = ASTInterpreter.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "assignment", self, aBlock);
                        }
                    }
                    catch (JumpException excptn) {
                        // empty catch block
                    }
                }
                return null;
            }
            case BACKREFNODE: {
                IRubyObject backref = context.getCurrentFrame().getBackRef();
                if (backref instanceof RubyMatchData) {
                    return "$" + ((BackRefNode)node).getType();
                }
                return null;
            }
            case CALLNODE: {
                CallNode iVisited = (CallNode)node;
                if (ASTInterpreter.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = ASTInterpreter.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                        }
                    }
                    catch (JumpException excptn) {
                        // empty catch block
                    }
                }
                return null;
            }
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: {
                return "assignment";
            }
            case CLASSVARNODE: {
                ClassVarNode iVisited = (ClassVarNode)node;
                RubyModule module = context.getCurrentScope().getStaticScope().getModule();
                if (module == null && self.getMetaClass().fastIsClassVarDefined(iVisited.getName())) {
                    return "class variable";
                }
                if (module.fastIsClassVarDefined(iVisited.getName())) {
                    return "class variable";
                }
                IRubyObject attached = null;
                if (module.isSingleton()) {
                    attached = ((MetaClass)module).getAttached();
                }
                if (attached instanceof RubyModule && (module = (RubyModule)attached).fastIsClassVarDefined(iVisited.getName())) {
                    return "class variable";
                }
                return null;
            }
            case COLON3NODE: 
            case COLON2NODE: {
                Colon3Node iVisited = (Colon3Node)node;
                try {
                    IRubyObject left = runtime.getObject();
                    if (iVisited instanceof Colon2Node) {
                        left = ASTInterpreter.eval(runtime, context, ((Colon2Node)iVisited).getLeftNode(), self, aBlock);
                    }
                    if (left instanceof RubyModule && ((RubyModule)left).fastGetConstantAt(iVisited.getName()) != null) {
                        return "constant";
                    }
                    if (left.getMetaClass().isMethodBound(iVisited.getName(), true)) {
                        return "method";
                    }
                }
                catch (JumpException excptn) {
                    // empty catch block
                }
                return null;
            }
            case CONSTNODE: {
                if (context.getConstantDefined(((ConstNode)node).getName())) {
                    return "constant";
                }
                return null;
            }
            case DVARNODE: {
                return "local-variable(in-block)";
            }
            case FALSENODE: {
                return "false";
            }
            case FCALLNODE: {
                FCallNode iVisited = (FCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                }
                return null;
            }
            case GLOBALVARNODE: {
                if (runtime.getGlobalVariables().isDefined(((GlobalVarNode)node).getName())) {
                    return "global-variable";
                }
                return null;
            }
            case INSTVARNODE: {
                if (self.getInstanceVariables().fastHasInstanceVariable(((InstVarNode)node).getName())) {
                    return "instance-variable";
                }
                return null;
            }
            case LOCALVARNODE: {
                return "local-variable";
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return "method";
            }
            case NILNODE: {
                return "nil";
            }
            case NTHREFNODE: {
                IRubyObject backref = context.getCurrentFrame().getBackRef();
                if (backref instanceof RubyMatchData) {
                    ((RubyMatchData)backref).use();
                    if (!((RubyMatchData)backref).group(((NthRefNode)node).getMatchNumber()).isNil()) {
                        return "$" + ((NthRefNode)node).getMatchNumber();
                    }
                }
                return null;
            }
            case SELFNODE: {
                return "self";
            }
            case SUPERNODE: {
                SuperNode iVisited = (SuperNode)node;
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "super", self, aBlock);
                }
                return null;
            }
            case TRUENODE: {
                return "true";
            }
            case VCALLNODE: {
                VCallNode iVisited = (VCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return "method";
                }
                return null;
            }
            case YIELDNODE: {
                return aBlock.isGiven() ? "yield" : null;
            }
            case ZSUPERNODE: {
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return "super";
                }
                return null;
            }
        }
        try {
            ASTInterpreter.eval(runtime, context, node, self, aBlock);
            return "expression";
        }
        catch (JumpException jumpExcptn) {
            return null;
        }
    }

    public static RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, Colon3Node node, IRubyObject self, Block block) {
        if (node instanceof Colon2Node) {
            Node leftNode = ((Colon2Node)node).getLeftNode();
            if (leftNode != null) {
                return RuntimeHelpers.prepareClassNamespace(context, leftNode.interpret(runtime, context, self, block));
            }
            return context.getCurrentScope().getStaticScope().getModule();
        }
        return runtime.getObject();
    }

    public static IRubyObject[] setupArgs(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            String savedFile = context.getFile();
            int savedLine = context.getLine();
            int size = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size];
            for (int i = 0; i < size; ++i) {
                argsArray[i] = argsArrayNode.get(i).interpret(runtime, context, self, aBlock);
            }
            context.setFile(savedFile);
            context.setLine(savedLine);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(node.interpret(runtime, context, self, aBlock));
    }

    @Deprecated
    public static IRubyObject aValueSplat(Ruby runtime, IRubyObject value) {
        if (!(value instanceof RubyArray) || ((RubyArray)value).length().getLongValue() == 0L) {
            return runtime.getNil();
        }
        RubyArray array = (RubyArray)value;
        return array.getLength() == 1 ? array.first(IRubyObject.NULL_ARRAY) : array;
    }

    @Deprecated
    public static RubyArray arrayValue(Ruby runtime, IRubyObject value) {
        IRubyObject tmp = value.checkArrayType();
        if (tmp.isNil()) {
            if (value.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                if (!((value = value.callMethod(runtime.getCurrentContext(), MethodIndex.TO_A, "to_a")) instanceof RubyArray)) {
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)value;
            }
            return runtime.newArray(value);
        }
        return (RubyArray)tmp;
    }

    @Deprecated
    public static IRubyObject aryToAry(Ruby runtime, IRubyObject value) {
        if (value instanceof RubyArray) {
            return value;
        }
        if (value.respondsTo("to_ary")) {
            return TypeConverter.convertToType(value, runtime.getArray(), MethodIndex.TO_A, "to_ary", false);
        }
        return runtime.newArray(value);
    }

    @Deprecated
    public static RubyArray splatValue(Ruby runtime, IRubyObject value) {
        if (value.isNil()) {
            return runtime.newArray(value);
        }
        return ASTInterpreter.arrayValue(runtime, value);
    }

    @Deprecated
    public static RubyArray splatValue(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.splatValue(runtime, value);
    }

    @Deprecated
    public static IRubyObject aValueSplat(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.aValueSplat(runtime, value);
    }

    @Deprecated
    public static IRubyObject aryToAry(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.aryToAry(runtime, value);
    }
}

