/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProxyConstructor
extends JavaProxyReflectionObject
implements ParameterTypes {
    private final Constructor<?> proxyConstructor;
    private final Class<?>[] apparentParameterTypes;
    private final JavaProxyClass declaringProxyClass;

    JavaProxyConstructor(Ruby runtime, JavaProxyClass pClass, Constructor<?> constructor) {
        super(runtime, runtime.getJavaSupport().getJavaModule().fastGetClass("JavaProxyConstructor"));
        this.declaringProxyClass = pClass;
        this.proxyConstructor = constructor;
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int len = parameterTypes.length - 1;
        this.apparentParameterTypes = new Class[len];
        System.arraycopy(parameterTypes, 0, this.apparentParameterTypes, 0, len);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.apparentParameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.proxyConstructor.getExceptionTypes();
    }

    @Override
    public boolean isVarArgs() {
        return this.proxyConstructor.isVarArgs();
    }

    @JRubyMethod(name={"declaring_class"})
    public JavaProxyClass getDeclaringClass() {
        return this.declaringProxyClass;
    }

    public Object newInstance(Object[] args, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (args.length != this.apparentParameterTypes.length) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        Object[] realArgs = new Object[args.length + 1];
        System.arraycopy(args, 0, realArgs, 0, args.length);
        realArgs[args.length] = handler;
        return this.proxyConstructor.newInstance(realArgs);
    }

    public static RubyClass createJavaProxyConstructorClass(Ruby runtime, RubyModule javaProxyModule) {
        RubyClass result = javaProxyModule.defineClassUnder("JavaProxyConstructor", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(runtime, result);
        result.defineAnnotatedMethods(JavaProxyConstructor.class);
        return result;
    }

    @JRubyMethod
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getParameterTypes().length);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaProxyConstructor && this.proxyConstructor == ((JavaProxyConstructor)other).proxyConstructor;
    }

    @Override
    public int hashCode() {
        return this.proxyConstructor.hashCode();
    }

    protected String nameOnInspection() {
        return this.getDeclaringClass().nameOnInspection();
    }

    @Override
    public IRubyObject inspect() {
        StringBuilder result = new StringBuilder();
        result.append(this.nameOnInspection());
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            result.append(',');
        }
        result.append(")>");
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod
    public RubyArray argument_types() {
        return this.buildRubyArray(this.getParameterTypes());
    }

    @JRubyMethod(frame=true, rest=true)
    public RubyObject new_instance2(IRubyObject[] args, Block unusedBlock) {
        Arity.checkArgumentCount(this.getRuntime(), args, 2, 2);
        final IRubyObject self = args[0];
        final Ruby runtime = self.getRuntime();
        final RubyModule javaUtilities = runtime.getJavaSupport().getJavaUtilitiesModule();
        RubyArray constructor_args = (RubyArray)args[1];
        Class<?>[] parameterTypes = this.getParameterTypes();
        int count = (int)constructor_args.length().getLongValue();
        Object[] converted = new Object[count];
        for (int i = 0; i < count; ++i) {
            IRubyObject ith = constructor_args.aref(this.getRuntime().newFixnum(i));
            converted[i] = JavaUtil.convertArgument(this.getRuntime(), Java.ruby_to_java(this, ith, Block.NULL_BLOCK), parameterTypes[i]);
        }
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            public Object invoke(Object proxy, JavaProxyMethod m, Object[] nargs) throws Throwable {
                String name = m.getName();
                DynamicMethod method = self.getMetaClass().searchMethod(name);
                int v = method.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[nargs.length];
                int i = nargs.length;
                while (--i >= 0) {
                    newArgs[i] = Java.java_to_ruby(javaUtilities, JavaObject.wrap(runtime, nargs[i]), Block.NULL_BLOCK);
                }
                if (v < 0 || v == newArgs.length) {
                    return JavaUtil.convertRubyToJava(RuntimeHelpers.invoke(runtime.getCurrentContext(), self, name, newArgs, CallType.FUNCTIONAL, Block.NULL_BLOCK), m.getReturnType());
                }
                RubyClass superClass = self.getMetaClass().getSuperClass();
                return JavaUtil.convertRubyToJava(RuntimeHelpers.invokeAs(runtime.getCurrentContext(), superClass, self, name, newArgs, CallType.SUPER, Block.NULL_BLOCK), m.getReturnType());
            }
        };
        try {
            return JavaObject.wrap(this.getRuntime(), this.newInstance(converted, handler));
        }
        catch (Exception e) {
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @JRubyMethod(required=1, optional=1, frame=true)
    public RubyObject new_instance(IRubyObject[] args, Block block) {
        Object result;
        RubyProc proc;
        int size = Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) - 1;
        if (args[size] instanceof RubyProc) {
            proc = (RubyProc)args[size];
        } else {
            proc = this.getRuntime().newProc(Block.Type.PROC, block);
            ++size;
        }
        RubyArray constructor_args = (RubyArray)args[0];
        Class<?>[] parameterTypes = this.getParameterTypes();
        int count = (int)constructor_args.length().getLongValue();
        Object[] converted = new Object[count];
        for (int i = 0; i < count; ++i) {
            IRubyObject ith = constructor_args.aref(this.getRuntime().newFixnum(i));
            converted[i] = JavaUtil.convertArgument(this.getRuntime(), Java.ruby_to_java(this, ith, Block.NULL_BLOCK), parameterTypes[i]);
        }
        final JavaProxyConstructor recv = this;
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            public Object invoke(Object proxy, JavaProxyMethod method, Object[] nargs) throws Throwable {
                int length = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(recv.getRuntime(), proxy);
                rubyArgs[1] = method;
                for (int i = 0; i < length; ++i) {
                    rubyArgs[i + 2] = JavaUtil.convertJavaToRuby(JavaProxyConstructor.this.getRuntime(), nargs[i]);
                }
                IRubyObject call_result = proc.call(JavaProxyConstructor.this.getRuntime().getCurrentContext(), rubyArgs);
                Object converted_result = JavaUtil.convertRubyToJava(call_result, method.getReturnType());
                return converted_result;
            }
        };
        try {
            result = this.newInstance(converted, handler);
        }
        catch (Exception e) {
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }
}

