/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    public void load(Ruby runtime, boolean wrap) {
        RubyClass ioClass = runtime.getIO();
        ioClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod(name={"ready?"})
    public static IRubyObject ready(IRubyObject obj) {
        RubyIO io = (RubyIO)obj;
        try {
            OpenFile openFile = io.getOpenFile();
            ChannelDescriptor descriptor = openFile.getMainStream().getDescriptor();
            if (!descriptor.isOpen() || !openFile.getMainStream().getModes().isReadable() || openFile.getMainStream().feof()) {
                return obj.getRuntime().getFalse();
            }
            int avail = openFile.getMainStream().ready();
            if (avail > 0) {
                return obj.getRuntime().newFixnum(avail);
            }
        }
        catch (Exception anyEx) {
            return obj.getRuntime().getFalse();
        }
        return obj.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject io_wait(IRubyObject obj) {
        RubyIO io = (RubyIO)obj;
        try {
            OpenFile openFile = io.getOpenFile();
            ChannelDescriptor descriptor = openFile.getMainStream().getDescriptor();
            if (openFile.getMainStream().feof()) {
                return obj.getRuntime().getNil();
            }
            openFile.getMainStream().waitUntilReady();
        }
        catch (Exception anyEx) {
            return obj.getRuntime().getNil();
        }
        return obj;
    }
}

