/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Parser {
    private final Ruby runtime;

    public Parser(Ruby runtime) {
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node parseRewriter(String file, InputStream content, ParserConfiguration configuration) throws SyntaxException {
        DefaultRubyParser parser = RubyParserPool.getInstance().borrowParser();
        try {
            parser.setWarnings(new NullWarnings());
            LexerSource lexerSource = LexerSource.getSource(file, content, null, configuration);
            Node node = parser.parse(configuration, lexerSource).getAST();
            return node;
        }
        finally {
            RubyParserPool.getInstance().returnParser(parser);
        }
    }

    public Node parse(String file, ByteList content, DynamicScope blockScope, ParserConfiguration configuration) {
        return this.parse(file, new ByteArrayInputStream(content.bytes()), blockScope, configuration);
    }

    public Node parse(String file, InputStream content, DynamicScope blockScope, ParserConfiguration configuration) {
        IRubyObject scriptLines = this.runtime.getObject().fastGetConstantAt("SCRIPT_LINES__");
        RubyArray list = null;
        if (!configuration.isEvalParse() && scriptLines != null && scriptLines instanceof RubyHash) {
            RubyString filename = this.runtime.newString(file);
            ThreadContext context = this.runtime.getCurrentContext();
            IRubyObject object = ((RubyHash)scriptLines).op_aref(context, filename);
            list = (RubyArray)(object instanceof RubyArray ? object : this.runtime.newArray());
            ((RubyHash)scriptLines).op_aset(context, filename, list);
        }
        if (blockScope != null) {
            configuration.parseAsBlock(blockScope);
        }
        DefaultRubyParser parser = null;
        RubyParserResult result = null;
        try {
            parser = RubyParserPool.getInstance().borrowParser();
            parser.setWarnings(this.runtime.getWarnings());
            LexerSource lexerSource = LexerSource.getSource(file, content, list, configuration);
            result = parser.parse(configuration, lexerSource);
            if (result.getEndOffset() >= 0) {
                IRubyObject verbose = this.runtime.getVerbose();
                this.runtime.setVerbose(this.runtime.getNil());
                this.runtime.defineGlobalConstant("DATA", new RubyFile(this.runtime, file, content));
                this.runtime.setVerbose(verbose);
                result.setEndOffset(-1);
            }
        }
        catch (SyntaxException e) {
            StringBuilder buffer = new StringBuilder(100);
            buffer.append(e.getPosition().getFile()).append(':');
            buffer.append(e.getPosition().getEndLine() + 1).append(": ");
            buffer.append(e.getMessage());
            throw this.runtime.newSyntaxError(buffer.toString());
        }
        finally {
            RubyParserPool.getInstance().returnParser(parser);
        }
        if (result.getScope() != null) {
            result.getScope().growIfNeeded();
        }
        return result.getAST();
    }
}

