/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.parsing;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxElementHandler
implements NamespaceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxElementHandler.class);
    private TxComponentMetaDataHelper metaDataHelper;
    private Interceptor interceptor = null;
    private Set<ComponentDefinitionRegistry> registered = new HashSet<ComponentDefinitionRegistry>();

    private void parseElement(Element elt, ComponentMetadata cm, ParserContext pc) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parser asked to parse .. " + elt);
        }
        if ("transaction".equals(elt.getLocalName())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("parser adding interceptor for " + elt);
            }
            ComponentDefinitionRegistry cdr = pc.getComponentDefinitionRegistry();
            if (cm == null) {
                String bean = elt.getAttribute("bean");
                this.registerComponentsWithInterceptor(cdr, bean);
                this.metaDataHelper.populateBundleWideTransactionData(pc.getComponentDefinitionRegistry(), elt.getAttribute("value"), elt.getAttribute("method"), bean);
            } else {
                cdr.registerInterceptorWithComponent(cm, this.interceptor);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("parser setting comp trans data for " + elt.getAttribute("value") + "  " + elt.getAttribute("method"));
                }
                this.metaDataHelper.setComponentTransactionData(cm, elt.getAttribute("value"), elt.getAttribute("method"));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parser done with " + elt);
        }
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata cm, ParserContext pc) {
        if (node instanceof Element) {
            Element elt = (Element)node;
            this.parseElement(elt, cm, pc);
        }
        return cm;
    }

    public Metadata parse(Element elt, ParserContext pc) {
        this.parseElement(elt, pc.getEnclosingComponent(), pc);
        return null;
    }

    public URL getSchemaLocation(String arg0) {
        if (arg0.equals("http://aries.apache.org/xmlns/transactions/v1.0.0")) {
            return this.getClass().getResource("transactionv10.xsd");
        }
        return this.getClass().getResource("transactionv11.xsd");
    }

    public final void setTxMetaDataHelper(TxComponentMetaDataHelper transactionEnhancer) {
        this.metaDataHelper = transactionEnhancer;
    }

    public final void setTransactionInterceptor(Interceptor itx) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parser having interceptor set " + itx);
        }
        this.interceptor = itx;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    private boolean isRegistered(ComponentDefinitionRegistry cdr) {
        for (ComponentDefinitionRegistry compdr : this.registered) {
            if (compdr != cdr) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerComponentsWithInterceptor(ComponentDefinitionRegistry cdr, String bean) {
        if (this.isRegistered(cdr)) {
            return;
        }
        Set ids = cdr.getComponentDefinitionNames();
        if (bean == null || bean.isEmpty()) {
            for (String id : ids) {
                ComponentMetadata componentMetadata = cdr.getComponentDefinition(id);
                cdr.registerInterceptorWithComponent(componentMetadata, this.interceptor);
            }
            Set<ComponentDefinitionRegistry> i$ = this.registered;
            synchronized (i$) {
                this.registered.add(cdr);
            }
        } else {
            Pattern p = Pattern.compile(bean);
            for (String id : ids) {
                Matcher m = p.matcher(id);
                if (!m.matches()) continue;
                ComponentMetadata componentMetadata = cdr.getComponentDefinition(id);
                cdr.registerInterceptorWithComponent(componentMetadata, this.interceptor);
            }
        }
    }
}

