/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.expression;

import java.io.IOException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.JaxenVariableContext;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JaxenXPathExpression
implements Expression,
InitializingBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(JaxenXPathExpression.class);
    private String xpath;
    private boolean useMessageContent = true;
    private SourceTransformer transformer = new SourceTransformer();
    private JaxenVariableContext variableContext = new JaxenVariableContext();
    private XPath xpathObject;
    private NamespaceContext namespaceContext;
    private FunctionContext functionContext;

    public JaxenXPathExpression() {
    }

    public JaxenXPathExpression(String xpath) throws Exception {
        this.xpath = xpath;
        this.init();
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void init() throws JaxenException {
        if (this.xpathObject == null) {
            if (this.xpath == null) {
                throw new IllegalArgumentException("You must specify the xpath property");
            }
            this.xpathObject = this.createXPath(this.xpath);
            this.xpathObject.setVariableContext((VariableContext)this.variableContext);
            if (this.namespaceContext != null) {
                this.xpathObject.setNamespaceContext(this.namespaceContext);
            }
            if (this.functionContext != null) {
                this.xpathObject.setFunctionContext(this.functionContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        try {
            Object object = this.getXMLNode(exchange, message);
            if (object == null) {
                return null;
            }
            JaxenXPathExpression jaxenXPathExpression = this;
            synchronized (jaxenXPathExpression) {
                this.variableContext.setExchange(exchange);
                this.variableContext.setMessage(message);
                return this.evaluateXPath(object);
            }
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (JaxenException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        try {
            Object object = this.getXMLNode(exchange, message);
            if (object == null) {
                return false;
            }
            JaxenXPathExpression jaxenXPathExpression = this;
            synchronized (jaxenXPathExpression) {
                this.variableContext.setExchange(exchange);
                this.variableContext.setMessage(message);
                return this.evaluateXPathAsBoolean(object);
            }
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (JaxenException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public XPath getXpathObject() {
        return this.xpathObject;
    }

    public void setXpathObject(XPath xpathObject) {
        this.xpathObject = xpathObject;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public boolean isUseMessageContent() {
        return this.useMessageContent;
    }

    public void setUseMessageContent(boolean useMessageContent) {
        this.useMessageContent = useMessageContent;
    }

    public SourceTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(SourceTransformer transformer) {
        this.transformer = transformer;
    }

    public JaxenVariableContext getVariableContext() {
        return this.variableContext;
    }

    public void setVariableContext(JaxenVariableContext variableContext) {
        this.variableContext = variableContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public FunctionContext getFunctionContext() {
        return this.functionContext;
    }

    public void setFunctionContext(FunctionContext functionContext) {
        this.functionContext = functionContext;
    }

    protected final XPath createXPath(String xp) throws JaxenException {
        return new DOMXPath(xp);
    }

    protected Object evaluateXPath(Object object) throws JaxenException {
        return this.xpathObject.evaluate(object);
    }

    protected boolean evaluateXPathAsBoolean(Object object) throws JaxenException {
        return this.xpathObject.booleanValueOf(object);
    }

    protected Object getXMLNode(MessageExchange exchange, NormalizedMessage message) throws TransformerException, MessagingException, ParserConfigurationException, IOException, SAXException {
        Node node = null;
        if (this.useMessageContent) {
            this.enableContentRereadability(message);
        }
        if (message != null) {
            node = this.transformer.toDOMNode(message);
        } else {
            LOG.warn("Null message for exchange: " + exchange);
        }
        if (node == null) {
            node = this.transformer.createDocument();
        }
        return node;
    }

    public void enableContentRereadability(NormalizedMessage message) throws MessagingException {
        if (message.getContent() instanceof StreamSource) {
            try {
                String content = this.transformer.contentToString(message);
                if (content != null) {
                    message.setContent((Source)new StringSource(content));
                }
            }
            catch (TransformerException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
            catch (IOException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
            catch (SAXException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
        }
    }
}

