/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.ehcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.base.BaseStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheStore
extends BaseStore
implements CacheEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EhCacheStore.class);
    private String name;
    private Cache cache;
    private IdGenerator idGenerator;

    public EhCacheStore(Cache cache, IdGenerator idGenerator, String name) {
        this.cache = cache;
        this.idGenerator = idGenerator;
        this.name = name;
        cache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
    }

    public boolean hasFeature(String feature) {
        if ("Persistent".equals(feature)) {
            return this.cache.getCacheConfiguration().isDiskPersistent();
        }
        return false;
    }

    public synchronized void destroy() throws Exception {
        this.cache.flush();
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug("Storing object with id: " + id);
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(data);
            out.close();
            Element element = new Element((Serializable)((Object)id), (Serializable)buffer.toByteArray());
            this.cache.put(element);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String store(Object data) throws IOException {
        String id = this.idGenerator.generateId();
        this.store(id, data);
        return id;
    }

    public Object load(String id) throws IOException {
        LOG.debug("Loading object with id: " + id);
        try {
            Object result = null;
            Element element = this.cache.get((Serializable)((Object)id));
            if (element != null) {
                byte[] data = (byte[])element.getValue();
                result = this.readObject(data);
                this.cache.remove((Serializable)((Object)id));
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Object peek(String id) throws IOException {
        LOG.debug("Peeking object with id: " + id);
        try {
            Object result = null;
            Element element = this.cache.get((Serializable)((Object)id));
            if (element != null) {
                byte[] data = (byte[])element.getValue();
                result = this.readObject(data);
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        Object result = null;
        if (data != null) {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            try {
                result = ois.readObject();
            }
            finally {
                ois.close();
            }
        }
        return result;
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        String id = (String)((Object)element.getKey());
        byte[] data = (byte[])element.getObjectValue();
        try {
            this.fireAddedEvent(id, this.readObject(data));
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this.notifyElementPut(cache, element);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        String id = (String)((Object)element.getKey());
        byte[] bytes = (byte[])element.getObjectValue();
        Object data = null;
        try {
            data = this.readObject(bytes);
            this.fireEvictedEvent(id, this.readObject(bytes));
        }
        catch (IOException e) {
            LOG.error("Error reading expired element", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Error reading expired element", (Throwable)e);
        }
        cache.removeQuiet((Serializable)((Object)id));
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        String id = (String)((Object)element.getKey());
        byte[] data = (byte[])element.getObjectValue();
        try {
            this.fireEvictedEvent(id, this.readObject(data));
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        String id = (String)((Object)element.getKey());
        byte[] data = (byte[])element.getObjectValue();
        try {
            if (data != null) {
                this.fireRemovedEvent(id, this.readObject(data));
            }
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

