/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.memory;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.Entry;
import org.apache.servicemix.store.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutMemoryStore
extends MemoryStore {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutMemoryStore.class);
    private ConcurrentMap<String, Entry> datas = new ConcurrentHashMap<String, Entry>();
    private final long timeout;

    protected TimeoutMemoryStore(IdGenerator idGenerator, long timeout) {
        super(idGenerator);
        this.timeout = timeout;
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug("Storing object with id: " + id);
        this.datas.put(id, new Entry(data));
        this.fireAddedEvent(id, data);
    }

    public Object load(String id) throws IOException {
        this.evict();
        LOG.debug("Loading object with id:" + id);
        Entry entry = (Entry)this.datas.remove(id);
        if (entry != null) {
            Object data = entry.getData();
            this.fireRemovedEvent(id, data);
            return data;
        }
        return null;
    }

    private void evict() {
        long now = System.currentTimeMillis();
        for (String key : this.datas.keySet()) {
            long age = now - ((Entry)this.datas.get(key)).getTime();
            if (age <= this.timeout) continue;
            LOG.debug("Removing object with id " + key + " from store after " + age + " ms");
            Entry entry = (Entry)this.datas.get(key);
            if (entry != null) {
                this.fireEvictedEvent(key, entry.getData());
            }
            this.datas.remove(key);
        }
    }
}

