/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;

public class ObjectMBean
implements DynamicMBean {
    private static Class[] OBJ_ARG = new Class[]{Object.class};
    protected Object _managed;
    private MBeanInfo _info;
    private Map _getters = new HashMap();
    private Map _setters = new HashMap();
    private Map _methods = new HashMap();
    private Set _convert = new HashSet();
    private ClassLoader _loader;
    private MBeanContainer _mbeanContainer;
    private static String OBJECT_NAME_CLASS = ObjectName.class.getName();
    private static String OBJECT_NAME_ARRAY_CLASS = ObjectName[].class.getName();

    public static Object mbeanFor(Object o) {
        try {
            Object mbean = null;
            for (Class<Object> oClass = o.getClass(); mbean == null && oClass != null; oClass = oClass.getSuperclass()) {
                String pName = oClass.getPackage().getName();
                String cName = oClass.getName().substring(pName.length() + 1);
                String mName = pName + ".jmx." + cName + "MBean";
                try {
                    block12: {
                        Class<Object> mClass;
                        Class<Object> clazz = mClass = Object.class.equals(oClass) ? (oClass = ObjectMBean.class) : Loader.loadClass(oClass, (String)mName, (boolean)true);
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("mbeanFor " + o + " mClass=" + mClass));
                        }
                        try {
                            Constructor constructor = mClass.getConstructor(OBJ_ARG);
                            mbean = constructor.newInstance(o);
                        }
                        catch (Exception e) {
                            Log.ignore((Throwable)e);
                            if (!ModelMBean.class.isAssignableFrom(mClass)) break block12;
                            mbean = mClass.newInstance();
                            ((ModelMBean)mbean).setManagedResource(o, "objectReference");
                        }
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("mbeanFor " + o + " is " + mbean));
                    }
                    return mbean;
                }
                catch (ClassNotFoundException e) {
                    String klass = e.getMessage().split("[ ]", 2)[0];
                    if (klass.endsWith("MBean")) {
                        Log.ignore((Throwable)e);
                        continue;
                    }
                    Log.warn((Throwable)e);
                    continue;
                }
                catch (Error e) {
                    Log.warn((Throwable)e);
                    mbean = null;
                    continue;
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                    mbean = null;
                }
            }
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
        return null;
    }

    public ObjectMBean(Object managedObject) {
        this._managed = managedObject;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public Object getManagedObject() {
        return this._managed;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public String getObjectContextBasis() {
        return null;
    }

    public String getObjectNameBasis() {
        return null;
    }

    protected void setMBeanContainer(MBeanContainer container) {
        this._mbeanContainer = container;
    }

    public MBeanContainer getMBeanContainer() {
        return this._mbeanContainer;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            if (this._info == null) {
                String desc = null;
                Object attributes = null;
                Object constructors = null;
                Object operations = null;
                Object notifications = null;
                Class<?> o_class = this._managed.getClass();
                Object influences = ObjectMBean.findInfluences(null, this._managed.getClass());
                HashSet<String> defined = new HashSet<String>();
                for (int i = 0; i < LazyList.size((Object)influences); ++i) {
                    Class<ObjectMBean> oClass = (Class<ObjectMBean>)LazyList.get((Object)influences, (int)i);
                    if (Object.class.equals((Object)oClass)) {
                        oClass = ObjectMBean.class;
                    }
                    String pName = oClass.getPackage().getName();
                    String cName = oClass.getName().substring(pName.length() + 1);
                    String rName = pName.replace('.', '/') + "/jmx/" + cName + "-mbean";
                    try {
                        Log.debug((String)rName);
                        ResourceBundle bundle = Loader.getResourceBundle(o_class, (String)rName, (boolean)true, (Locale)Locale.getDefault());
                        Enumeration<String> e = bundle.getKeys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement();
                            String value = bundle.getString(key);
                            if (key.equals(cName)) {
                                if (desc != null) continue;
                                desc = value;
                                continue;
                            }
                            if (key.indexOf(40) > 0) {
                                if (defined.contains(key) || key.indexOf(91) >= 0) continue;
                                defined.add(key);
                                operations = LazyList.add(operations, (Object)this.defineOperation(key, value, bundle));
                                continue;
                            }
                            if (defined.contains(key)) continue;
                            defined.add(key);
                            MBeanAttributeInfo info = this.defineAttribute(key, value);
                            if (info == null) continue;
                            attributes = LazyList.add(attributes, (Object)info);
                        }
                        continue;
                    }
                    catch (MissingResourceException e) {
                        Log.ignore((Throwable)e);
                    }
                }
                this._info = new MBeanInfo(o_class.getName(), desc, (MBeanAttributeInfo[])LazyList.toArray(attributes, MBeanAttributeInfo.class), (MBeanConstructorInfo[])LazyList.toArray(constructors, MBeanConstructorInfo.class), (MBeanOperationInfo[])LazyList.toArray(operations, MBeanOperationInfo.class), (MBeanNotificationInfo[])LazyList.toArray(notifications, MBeanNotificationInfo.class));
            }
        }
        catch (RuntimeException e) {
            Log.warn((Throwable)e);
            throw e;
        }
        return this._info;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter = (Method)this._getters.get(name);
        if (getter == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            Object r;
            Object o = this._managed;
            if (getter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((r = getter.invoke(o, (Object[])null)) != null && this._convert.contains(name)) {
                if (r.getClass().isArray()) {
                    ObjectName[] on = new ObjectName[Array.getLength(r)];
                    for (int i = 0; i < on.length; ++i) {
                        on[i] = this._mbeanContainer.findMBean(Array.get(r, i));
                    }
                    r = on;
                } else if (r instanceof Collection) {
                    Collection c = (Collection)r;
                    ObjectName[] on = new ObjectName[c.size()];
                    int i = 0;
                    for (Object obj : c) {
                        on[i++] = this._mbeanContainer.findMBean(obj);
                    }
                    r = on;
                } else {
                    ObjectName mbean = this._mbeanContainer.findMBean(r);
                    if (mbean == null) {
                        return null;
                    }
                    r = mbean;
                }
            }
            return r;
        }
        catch (IllegalAccessException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    public AttributeList getAttributes(String[] names) {
        AttributeList results = new AttributeList(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                results.add(new Attribute(names[i], this.getAttribute(names[i])));
                continue;
            }
            catch (Exception e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
            }
        }
        return results;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter;
        if (attr == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("setAttribute " + this._managed + ":" + attr.getName() + "=" + attr.getValue()));
        }
        if ((setter = (Method)this._setters.get(attr.getName())) == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object value;
            Object o = this._managed;
            if (setter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((value = attr.getValue()) != null && this._convert.contains(attr.getName())) {
                if (value.getClass().isArray()) {
                    Class<?> t = setter.getParameterTypes()[0].getComponentType();
                    Object na = Array.newInstance(t, Array.getLength(value));
                    int i = Array.getLength(value);
                    while (i-- > 0) {
                        Array.set(na, i, this._mbeanContainer.findBean((ObjectName)Array.get(value, i)));
                    }
                    value = na;
                } else {
                    value = this._mbeanContainer.findBean((ObjectName)value);
                }
            }
            setter.invoke(o, value);
        }
        catch (IllegalAccessException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    public AttributeList setAttributes(AttributeList attrs) {
        Log.debug((String)"setAttributes");
        AttributeList results = new AttributeList(attrs.size());
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
            }
        }
        return results;
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("invoke " + name));
        }
        String methodKey = name + "(";
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                methodKey = methodKey + (i > 0 ? "," : "") + signature[i];
            }
        }
        methodKey = methodKey + ")";
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            Method method = (Method)this._methods.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            Object o = this._managed;
            if (method.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            Object object = method.invoke(o, params);
            return object;
        }
        catch (NoSuchMethodException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    private static Object findInfluences(Object influences, Class aClass) {
        if (aClass != null) {
            influences = LazyList.add((Object)influences, (Object)aClass);
            influences = ObjectMBean.findInfluences(influences, aClass.getSuperclass());
            Class<?>[] ifs = aClass.getInterfaces();
            for (int i = 0; ifs != null && i < ifs.length; ++i) {
                influences = ObjectMBean.findInfluences(influences, ifs[i]);
            }
        }
        return influences;
    }

    public MBeanAttributeInfo defineAttribute(String name, String metaData) {
        Class<?> oClass;
        String description = "";
        boolean writable = true;
        boolean onMBean = false;
        boolean convert = false;
        if (metaData != null) {
            String[] tokens = metaData.split(":", 3);
            for (int t = 0; t < tokens.length - 1; ++t) {
                tokens[t] = tokens[t].trim();
                if ("RO".equals(tokens[t])) {
                    writable = false;
                    continue;
                }
                onMBean = "MMBean".equalsIgnoreCase(tokens[t]) || "MBean".equalsIgnoreCase(tokens[t]);
                convert = "MMBean".equalsIgnoreCase(tokens[t]) || "MObject".equalsIgnoreCase(tokens[t]);
            }
            description = tokens[tokens.length - 1];
        }
        String uName = name.substring(0, 1).toUpperCase() + name.substring(1);
        Class<?> clazz = oClass = onMBean ? this.getClass() : this._managed.getClass();
        if (Log.isDebugEnabled()) {
            Log.debug((String)("defineAttribute " + name + " " + onMBean + ":" + writable + ":" + oClass + ":" + description));
        }
        Class<?> type = null;
        Method getter = null;
        Method setter = null;
        Method[] methods = oClass.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            if ((methods[m].getModifiers() & 1) == 0) continue;
            if (methods[m].getName().equals("get" + uName) && methods[m].getParameterTypes().length == 0) {
                if (getter != null) {
                    Log.warn((String)("Multiple mbean getters for attr " + name + " in " + oClass));
                    continue;
                }
                getter = methods[m];
                if (type != null && !type.equals(methods[m].getReturnType())) {
                    Log.warn((String)("Type conflict for mbean attr " + name + " in " + oClass));
                    continue;
                }
                type = methods[m].getReturnType();
            }
            if (methods[m].getName().equals("is" + uName) && methods[m].getParameterTypes().length == 0) {
                if (getter != null) {
                    Log.warn((String)("Multiple mbean getters for attr " + name + " in " + oClass));
                    continue;
                }
                getter = methods[m];
                if (type != null && !type.equals(methods[m].getReturnType())) {
                    Log.warn((String)("Type conflict for mbean attr " + name + " in " + oClass));
                    continue;
                }
                type = methods[m].getReturnType();
            }
            if (!writable || !methods[m].getName().equals("set" + uName) || methods[m].getParameterTypes().length != 1) continue;
            if (setter != null) {
                Log.warn((String)("Multiple setters for mbean attr " + name + " in " + oClass));
                continue;
            }
            setter = methods[m];
            if (type != null && !type.equals(methods[m].getParameterTypes()[0])) {
                Log.warn((String)("Type conflict for mbean attr " + name + " in " + oClass));
                continue;
            }
            type = methods[m].getParameterTypes()[0];
        }
        if (convert) {
            if (type == null) {
                Log.warn((String)("No mbean type for " + name + " on " + this._managed.getClass()));
                return null;
            }
            if (type.isPrimitive() && !type.isArray()) {
                Log.warn((String)("Cannot convert mbean primative " + name));
                return null;
            }
        }
        if (getter == null && setter == null) {
            Log.warn((String)("No mbean getter or setters found for " + name + " in " + oClass));
            return null;
        }
        try {
            this._getters.put(name, getter);
            this._setters.put(name, setter);
            MBeanAttributeInfo info = null;
            if (convert) {
                this._convert.add(name);
                info = type.isArray() ? new MBeanAttributeInfo(name, OBJECT_NAME_ARRAY_CLASS, description, getter != null, setter != null, getter != null && getter.getName().startsWith("is")) : new MBeanAttributeInfo(name, OBJECT_NAME_CLASS, description, getter != null, setter != null, getter != null && getter.getName().startsWith("is"));
            } else {
                info = new MBeanAttributeInfo(name, description, getter, setter);
            }
            return info;
        }
        catch (Exception e) {
            Log.warn((String)(name + ": " + metaData), (Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    private MBeanOperationInfo defineOperation(String signature, String metaData, ResourceBundle bundle) {
        boolean convert;
        String impact_name;
        String[] tokens = metaData.split(":", 3);
        int i = tokens.length - 1;
        String description = tokens[i--];
        String string = impact_name = i < 0 ? "UNKNOWN" : tokens[i--].trim();
        if (i == 0) {
            tokens[0] = tokens[0].trim();
        }
        boolean onMBean = i == 0 && ("MBean".equalsIgnoreCase(tokens[0]) || "MMBean".equalsIgnoreCase(tokens[0]));
        boolean bl = convert = i == 0 && ("MObject".equalsIgnoreCase(tokens[0]) || "MMBean".equalsIgnoreCase(tokens[0]));
        if (Log.isDebugEnabled()) {
            Log.debug((String)("defineOperation " + signature + " " + onMBean + ":" + impact_name + ":" + description));
        }
        Class<?> oClass = onMBean ? this.getClass() : this._managed.getClass();
        try {
            int impact = 3;
            if (impact_name == null || impact_name.equals("UNKNOWN")) {
                impact = 3;
            } else if (impact_name.equals("ACTION")) {
                impact = 1;
            } else if (impact_name.equals("INFO")) {
                impact = 0;
            } else if (impact_name.equals("ACTION_INFO")) {
                impact = 2;
            } else {
                Log.warn((String)("Unknown impact '" + impact_name + "' for " + signature));
            }
            String[] parts = signature.split("[\\(\\)]");
            String method_name = parts[0];
            String arguments = parts.length == 2 ? parts[1] : null;
            String[] args = arguments == null ? new String[]{} : arguments.split(" *, *");
            Class[] types = new Class[args.length];
            MBeanParameterInfo[] pInfo = new MBeanParameterInfo[args.length];
            signature = method_name;
            for (i = 0; i < args.length; ++i) {
                Class<?> type = TypeUtil.fromName((String)args[i]);
                if (type == null) {
                    type = Thread.currentThread().getContextClassLoader().loadClass(args[i]);
                }
                types[i] = type;
                args[i] = type.isPrimitive() ? TypeUtil.toName(type) : args[i];
                signature = signature + (i > 0 ? "," : "(") + args[i];
            }
            signature = signature + (i > 0 ? ")" : "()");
            for (i = 0; i < args.length; ++i) {
                String param_desc = bundle.getString(signature + "[" + i + "]");
                parts = param_desc.split(" *: *", 2);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(parts[0] + ": " + parts[1]));
                }
                pInfo[i] = new MBeanParameterInfo(parts[0].trim(), args[i], parts[1].trim());
            }
            Method method = oClass.getMethod(method_name, types);
            Class<?> returnClass = method.getReturnType();
            this._methods.put(signature, method);
            if (convert) {
                this._convert.add(signature);
            }
            return new MBeanOperationInfo(method_name, description, pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact);
        }
        catch (Exception e) {
            Log.warn((String)("Operation '" + signature + "'"), (Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }
}

