/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.i18n.text.Sanitizer;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.error.Error;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.AbstractResponseContext;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.abdera.writer.NamedWriter;
import org.apache.abdera.writer.StreamWriter;
import org.apache.abdera.writer.WriterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderHelper {
    private static final Log log = LogFactory.getLog(ProviderHelper.class);

    private ProviderHelper() {
    }

    public static int getPageSize(RequestContext request, String pagesizeparam, int defaultpagesize) {
        int size = defaultpagesize;
        try {
            String _ps = request.getParameter(pagesizeparam);
            size = _ps != null ? Math.min(Math.max(Integer.parseInt(_ps), 0), defaultpagesize) : defaultpagesize;
        }
        catch (Exception e) {
            // empty catch block
        }
        log.debug((Object)Localizer.sprintf("PAGE.SIZE", size));
        return size;
    }

    public static int getOffset(RequestContext request, String pageparam, int pageSize) {
        int offset = 0;
        try {
            String _page = request.getParameter(pageparam);
            int page = _page != null ? Integer.parseInt(_page) : 1;
            page = Math.max(page, 1) - 1;
            offset = pageSize * page;
        }
        catch (Exception e) {
            // empty catch block
        }
        log.debug((Object)Localizer.sprintf("OFFSET", offset));
        return offset;
    }

    public static AbstractResponseContext createErrorResponse(Abdera abdera, int code, String message) {
        return ProviderHelper.createErrorResponse(abdera, code, message, null);
    }

    public static AbstractResponseContext createErrorResponse(Abdera abdera, final int code, final String message, final Throwable t) {
        StreamWriterResponseContext rc = new StreamWriterResponseContext(abdera){

            protected void writeTo(StreamWriter sw) throws IOException {
                Error.create(sw, code, message, t);
            }
        };
        rc.setStatus(code);
        rc.setStatusText(message);
        return rc;
    }

    public static ResponseContext servererror(RequestContext request, String reason, Throwable t) {
        log.info((Object)Localizer.get("SERVER_ERROR"), t);
        return ProviderHelper.createErrorResponse(request.getAbdera(), 500, reason, t);
    }

    public static ResponseContext servererror(RequestContext request, Throwable t) {
        return ProviderHelper.servererror(request, "Server Error", t);
    }

    public static ResponseContext unauthorized(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("UNAUTHORIZED"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 401, reason);
    }

    public static ResponseContext unauthorized(RequestContext request) {
        return ProviderHelper.unauthorized(request, "Unauthorized");
    }

    public static ResponseContext forbidden(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("FORBIDDEN"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 403, reason);
    }

    public static ResponseContext forbidden(RequestContext request) {
        return ProviderHelper.forbidden(request, "Forbidden");
    }

    public static ResponseContext nocontent(String reason) {
        return new EmptyResponseContext(204, reason);
    }

    public static ResponseContext nocontent() {
        return ProviderHelper.nocontent("Not Content");
    }

    public static ResponseContext notfound(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("UNKNOWN"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 404, reason);
    }

    public static ResponseContext notfound(RequestContext request) {
        return ProviderHelper.notfound(request, "Not Found");
    }

    public static ResponseContext notallowed(RequestContext request, String reason, String ... methods) {
        log.debug((Object)Localizer.get("NOT.ALLOWED"));
        AbstractResponseContext resp = ProviderHelper.createErrorResponse(request.getAbdera(), 405, reason);
        resp.setAllow(methods);
        return resp;
    }

    public static ResponseContext notallowed(RequestContext request, String ... methods) {
        return ProviderHelper.notallowed(request, "Method Not Allowed", methods);
    }

    public static ResponseContext notallowed(RequestContext request) {
        return ProviderHelper.notallowed(request, ProviderHelper.getDefaultMethods(request));
    }

    public static ResponseContext badrequest(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("BAD.REQUEST"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 400, reason);
    }

    public static ResponseContext badrequest(RequestContext request) {
        return ProviderHelper.badrequest(request, "Bad Request");
    }

    public static ResponseContext conflict(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("CONFLICT"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 409, reason);
    }

    public static ResponseContext conflict(RequestContext request) {
        return ProviderHelper.conflict(request, "Conflict");
    }

    public static ResponseContext unavailable(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("UNAVAILABLE"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 503, reason);
    }

    public static ResponseContext unavailable(RequestContext request) {
        return ProviderHelper.unavailable(request, "Service Unavailable");
    }

    public static ResponseContext notmodified(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("NOT.MODIFIED"));
        return new EmptyResponseContext(304, reason);
    }

    public static ResponseContext notmodified(RequestContext request) {
        return ProviderHelper.notmodified(request, "Not Modified");
    }

    public static ResponseContext preconditionfailed(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("PRECONDITION.FAILED"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 412, reason);
    }

    public static ResponseContext preconditionfailed(RequestContext request) {
        return ProviderHelper.preconditionfailed(request, "Precondition Failed");
    }

    public static ResponseContext notsupported(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("NOT.SUPPORTED"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 415, reason);
    }

    public static ResponseContext notsupported(RequestContext request) {
        return ProviderHelper.notsupported(request, "Media Type Not Supported");
    }

    public static ResponseContext locked(RequestContext request, String reason) {
        log.debug((Object)Localizer.get("LOCKED"));
        return ProviderHelper.createErrorResponse(request.getAbdera(), 423, reason);
    }

    public static ResponseContext locked(RequestContext request) {
        return ProviderHelper.locked(request, "Locked");
    }

    public static ResponseContext returnBase(Base base, int status, Date lastModified) {
        Document doc;
        log.debug((Object)Localizer.get("RETURNING.DOCUMENT"));
        BaseResponseContext<Base> response = new BaseResponseContext<Base>(base);
        response.setStatus(status);
        if (lastModified != null) {
            response.setLastModified(lastModified);
        }
        response.setContentType(MimeTypeHelper.getMimeType(base));
        Document document = doc = base instanceof Document ? (Document)base : ((Element)base).getDocument();
        if (doc.getEntityTag() != null) {
            response.setEntityTag(doc.getEntityTag());
        } else if (doc.getLastModified() != null) {
            response.setLastModified(doc.getLastModified());
        }
        return response;
    }

    public static String sanitizeSlug(String slug) {
        if (slug == null) {
            throw new IllegalArgumentException(Localizer.get("SLUG.NOT.NULL"));
        }
        String sanitized = Sanitizer.sanitize(slug);
        log.debug((Object)Localizer.sprintf("SLUG.SANITIZED", slug, sanitized));
        return sanitized;
    }

    public static boolean isValidEntry(Entry entry) {
        try {
            IRI id = entry.getId();
            if (id == null || id.toString().trim().length() == 0 || !id.isAbsolute()) {
                return false;
            }
            if (entry.getTitle() == null) {
                return false;
            }
            if (entry.getUpdated() == null) {
                return false;
            }
            if (entry.getAuthor() == null && entry.getSource() != null && entry.getAuthor() == null) {
                return false;
            }
            Content content = entry.getContentElement();
            if (content == null) {
                if (entry.getAlternateLink() == null) {
                    return false;
                }
            } else if ((content.getSrc() != null || content.getContentType() == Content.Type.MEDIA) && entry.getSummaryElement() == null) {
                log.debug((Object)Localizer.sprintf("CHECKING.VALID.ENTRY", false));
                return false;
            }
        }
        catch (Exception e) {
            log.debug((Object)Localizer.sprintf("CHECKING.VALID.ENTRY", false));
            return false;
        }
        log.debug((Object)Localizer.sprintf("CHECKING.VALID.ENTRY", true));
        return true;
    }

    public static boolean checkElementNamespaces(Element element, List<String> ignore) {
        List<QName> attrs = element.getExtensionAttributes();
        for (QName qname : attrs) {
            String ns = qname.getNamespaceURI();
            if (ignore.contains(ns)) continue;
            return false;
        }
        if (element instanceof ExtensibleElement) {
            ExtensibleElement ext = (ExtensibleElement)element;
            List<Element> extensions = ext.getExtensions();
            for (Element el : extensions) {
                QName qname = el.getQName();
                String ns = qname.getNamespaceURI();
                if (!ignore.contains(ns)) {
                    return false;
                }
                if (ProviderHelper.checkElementNamespaces(el, ignore)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean beforeOrEqual(Date d1, Date d2) {
        long l2;
        long l1 = d1.getTime() / 1000L;
        return l1 <= (l2 = d2.getTime() / 1000L);
    }

    public static IRI resolveBase(RequestContext request) {
        return request.getBaseUri().resolve(request.getUri());
    }

    public static String combine(String ... vals) {
        StringBuilder buf = new StringBuilder();
        for (String val : vals) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public static String[] getDefaultMethods(RequestContext request) {
        TargetType type = request.getTarget().getType();
        if (type == null) {
            return new String[0];
        }
        if (type == TargetType.TYPE_COLLECTION) {
            return new String[]{"GET", "HEAD", "OPTIONS", "POST"};
        }
        if (type == TargetType.TYPE_CATEGORIES) {
            return new String[]{"GET", "HEAD", "OPTIONS"};
        }
        if (type == TargetType.TYPE_ENTRY) {
            return new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT"};
        }
        if (type == TargetType.TYPE_MEDIA) {
            return new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT"};
        }
        if (type == TargetType.TYPE_SERVICE) {
            return new String[]{"GET", "HEAD", "OPTIONS"};
        }
        return new String[]{"GET", "HEAD", "OPTIONS"};
    }

    public static boolean defaultCheckMethod(RequestContext request, String[] methods) {
        return Arrays.binarySearch(methods, request.getMethod()) >= 0;
    }

    public static boolean isAtom(RequestContext request) {
        MimeType mt = request.getContentType();
        String ctype = mt != null ? mt.toString() : null;
        return ctype != null && MimeTypeHelper.isAtom(ctype);
    }

    public static String[] orderByQ(String header) {
        if (header == null || header.length() == 0) {
            return new String[0];
        }
        String[] tokens = header.split(",");
        QToken[] qtokens = new QToken[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            String[] qvalues = token.trim().split(";");
            String t = qvalues[0];
            if (qvalues.length > 1) {
                for (int n = 1; n < qvalues.length; ++n) {
                    String[] v = qvalues[n].trim().split("=");
                    if (!v[0].trim().equals("q")) continue;
                    double qv = Double.parseDouble(v[1]);
                    qtokens[i] = new QToken(t, qv);
                    break;
                }
            }
            if (qtokens[i] != null) continue;
            qtokens[i] = new QToken(t, 1.0);
        }
        Arrays.sort(qtokens, new QTokenComparator());
        tokens = new String[qtokens.length];
        for (int n = 0; n < qtokens.length; ++n) {
            tokens[n] = qtokens[n].token;
        }
        return tokens;
    }

    public static NamedWriter getAcceptableNamedWriter(Abdera abdera, String accept_header) {
        String[] sorted_accepts = ProviderHelper.orderByQ(accept_header);
        WriterFactory factory = abdera.getWriterFactory();
        if (factory == null) {
            return null;
        }
        for (String accept : sorted_accepts) {
            NamedWriter writer = (NamedWriter)factory.getWriterByMediaType(accept);
            if (writer == null) continue;
            return writer;
        }
        return null;
    }

    public static NamedWriter getNamedWriter(Abdera abdera, String mediatype) {
        WriterFactory factory = abdera.getWriterFactory();
        if (factory == null) {
            return null;
        }
        NamedWriter writer = (NamedWriter)factory.getWriterByMediaType(mediatype);
        return writer;
    }

    public static EntityTag calculateEntityTag(Base base) {
        String id = null;
        String modified = null;
        if (base instanceof Entry) {
            Entry entry = (Entry)base;
            id = entry.getId().toString();
            modified = AtomDate.format(entry.getEdited() != null ? entry.getEdited() : entry.getUpdated());
        } else if (base instanceof Feed) {
            Feed feed = (Feed)base;
            id = feed.getId().toString();
            modified = AtomDate.format(feed.getUpdated());
        } else if (base instanceof Document) {
            return ProviderHelper.calculateEntityTag(((Document)base).getRoot());
        }
        return EntityTag.generate(id, modified);
    }

    public static String getEditUriFromEntry(Entry entry) {
        String editUri = null;
        List<Link> editLinks = entry.getLinks("edit");
        if (editLinks != null) {
            for (Link link : editLinks) {
                if (link.getMimeType() != null) {
                    if (!MimeTypeHelper.isMatch(link.getMimeType().toString(), "application/atom+xml")) continue;
                    editUri = link.getResolvedHref().toString();
                    break;
                }
                editUri = link.getResolvedHref().toString();
                break;
            }
        }
        return editUri;
    }

    public static String[] getAcceptableTypes(RequestContext request) {
        String accept = request.getAccept();
        return ProviderHelper.orderByQ(accept);
    }

    public static boolean isPreferred(RequestContext request, String s1, String s2) {
        return ProviderHelper.isPreferred(ProviderHelper.getAcceptableTypes(request), s1, s2);
    }

    public static boolean isPreferred(String[] accepts, String s1, String s2) {
        int n;
        int i1 = accepts.length;
        int i2 = accepts.length;
        for (n = 0; n < accepts.length; ++n) {
            if (!MimeTypeHelper.isMatch(s1, accepts[n])) continue;
            i1 = n;
            break;
        }
        for (n = 0; n < accepts.length; ++n) {
            if (!MimeTypeHelper.isMatch(s2, accepts[n])) continue;
            i2 = n;
            break;
        }
        return i1 < i2;
    }

    private static class QToken {
        String token;
        double qvalue = 1.0;

        QToken(String token, double qvalue) {
            this.token = token;
            this.qvalue = qvalue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QTokenComparator
    implements Comparator<QToken> {
        private QTokenComparator() {
        }

        @Override
        public int compare(QToken o1, QToken o2) {
            if (o1.qvalue > o2.qvalue) {
                return -1;
            }
            if (o1.qvalue < o2.qvalue) {
                return 1;
            }
            return 0;
        }
    }
}

