/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.WorkspaceManager;
import org.apache.abdera.protocol.server.impl.AbstractProvider;
import org.apache.abdera.protocol.server.impl.DefaultWorkspaceManager;
import org.apache.abdera.protocol.server.impl.RouteManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProvider
extends AbstractProvider {
    protected WorkspaceManager workspaceManager;
    protected Resolver<Target> targetResolver;
    protected Resolver<Subject> subjectResolver;
    protected TargetBuilder targetBuilder;
    protected RouteManager routeManager;

    public DefaultProvider() {
        this("/");
    }

    public DefaultProvider(String base) {
        if (base == null) {
            base = "/";
        }
        this.workspaceManager = new DefaultWorkspaceManager();
        this.routeManager = new RouteManager().addRoute("service", base, TargetType.TYPE_SERVICE).addRoute("feed", base + ":collection", TargetType.TYPE_COLLECTION).addRoute("entry", base + ":collection/:entry", TargetType.TYPE_ENTRY).addRoute("categories", base + ":collection/:entry;categories", TargetType.TYPE_CATEGORIES);
        this.targetBuilder = this.routeManager;
        this.targetResolver = this.routeManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    @Override
    protected Resolver<Target> getTargetResolver(RequestContext request) {
        return this.targetResolver;
    }

    public void setTargetResolver(Resolver<Target> targetResolver) {
        this.targetResolver = targetResolver;
    }

    @Override
    protected Resolver<Subject> getSubjectResolver(RequestContext request) {
        return this.subjectResolver;
    }

    public void setSubjectResolver(Resolver<Subject> subjectResolver) {
        this.subjectResolver = subjectResolver;
    }

    public Resolver<Target> getTargetResolver() {
        return this.targetResolver;
    }

    public Resolver<Subject> getSubjectResolver() {
        return this.subjectResolver;
    }

    @Override
    protected WorkspaceManager getWorkspaceManager(RequestContext request) {
        return this.getWorkspaceManager();
    }

    public WorkspaceManager getWorkspaceManager() {
        return this.workspaceManager;
    }

    public void setWorkspaceManager(WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public TargetBuilder getTargetBuilder() {
        return this.targetBuilder;
    }

    public void setTargetBuilder(TargetBuilder targetBuilder) {
        this.targetBuilder = targetBuilder;
    }

    public void addWorkspace(WorkspaceInfo workspace) {
        ((DefaultWorkspaceManager)this.getWorkspaceManager()).addWorkspace(workspace);
    }

    public void addWorkspaces(Collection<WorkspaceInfo> workspaces) {
        for (WorkspaceInfo w : workspaces) {
            ((DefaultWorkspaceManager)this.getWorkspaceManager()).addWorkspace(w);
        }
    }

    @Override
    protected TargetBuilder getTargetBuilder(RequestContext request) {
        return this.targetBuilder;
    }
}

