/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.abdera.model.Collection;
import org.apache.abdera.protocol.server.CategoriesInfo;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;

public class SimpleCollectionInfo
implements CollectionInfo,
Serializable {
    private static final long serialVersionUID = 8026455829158149510L;
    private final String title;
    private final String href;
    private final String[] accepts;
    private final List<CategoriesInfo> catinfos = new ArrayList<CategoriesInfo>();

    public SimpleCollectionInfo(String title, String href, String ... accepts) {
        this.title = title;
        this.accepts = accepts;
        this.href = href;
    }

    public String[] getAccepts(RequestContext request) {
        return this.accepts;
    }

    public String getHref(RequestContext request) {
        return this.href;
    }

    public String getTitle(RequestContext request) {
        return this.title;
    }

    public CategoriesInfo[] getCategoriesInfo(RequestContext request) {
        return this.catinfos.toArray(new CategoriesInfo[this.catinfos.size()]);
    }

    public void addCategoriesInfo(CategoriesInfo ... catinfos) {
        for (CategoriesInfo catinfo : catinfos) {
            this.catinfos.add(catinfo);
        }
    }

    public void setCategoriesInfo(CategoriesInfo ... catinfos) {
        this.catinfos.clear();
        this.addCategoriesInfo(catinfos);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.accepts);
        result = 31 * result + (this.catinfos == null ? 0 : ((Object)this.catinfos).hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleCollectionInfo other = (SimpleCollectionInfo)obj;
        if (!Arrays.equals(this.accepts, other.accepts)) {
            return false;
        }
        if (this.catinfos == null ? other.catinfos != null : !((Object)this.catinfos).equals(other.catinfos)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public Collection asCollectionElement(RequestContext request) {
        Collection collection = request.getAbdera().getFactory().newCollection();
        collection.setHref(this.href);
        collection.setTitle(this.title);
        collection.setAccept(this.accepts);
        for (CategoriesInfo catsinfo : this.catinfos) {
            collection.addCategories(catsinfo.asCategoriesElement(request));
        }
        return collection;
    }
}

