/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ServletHandler;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceRequestWrapper;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceResponseWrapper;
import org.osgi.service.http.HttpContext;

class HttpServiceServletHandler
extends ServletHandler {
    private static final Log LOG = LogFactory.getLog(HttpServiceServletHandler.class);
    private final HttpContext m_httpContext;
    private static final String METHOD_TRACE = "TRACE";

    HttpServiceServletHandler(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        this.m_httpContext = httpContext;
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServiceResponseWrapper responseWrapper;
        HttpServiceRequestWrapper requestWrapper;
        if (request.getMethod().equals(METHOD_TRACE)) {
            throw new ServletException("HTTP TRACE method is disabled");
        }
        if (baseRequest.getAttribute("org.ops4j.pax.web.service.internal.jettyRequest") == null) {
            baseRequest.setAttribute("org.ops4j.pax.web.service.internal.jettyRequest", (Object)request);
        }
        if (this.m_httpContext.handleSecurity((HttpServletRequest)(requestWrapper = new HttpServiceRequestWrapper(request)), (HttpServletResponse)(responseWrapper = new HttpServiceResponseWrapper(response)))) {
            super.doHandle(target, baseRequest, request, response);
        } else if (!responseWrapper.isCommitted()) {
            if (!responseWrapper.isStatusSet()) {
                responseWrapper.sendError(401);
            } else {
                responseWrapper.sendError(responseWrapper.getStatus());
            }
        }
    }
}

