/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.endpoints;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.SimpleEndpoint;

public abstract class ProviderEndpoint
extends SimpleEndpoint {
    private ServiceEndpoint activated;

    public ProviderEndpoint() {
    }

    public ProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public ProviderEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component.getServiceUnit(), endpoint.getServiceName(), endpoint.getEndpointName());
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.PROVIDER;
    }

    public void activate() throws Exception {
        super.activate();
        ComponentContext ctx = this.getServiceUnit().getComponent().getComponentContext();
        this.activated = ctx.activateEndpoint(this.service, this.endpoint);
    }

    public void deactivate() throws Exception {
        if (this.activated == null) {
            throw new IllegalStateException("Endpoint not activated: " + this);
        }
        ServiceEndpoint ep = this.activated;
        this.activated = null;
        ComponentContext ctx = this.getServiceUnit().getComponent().getComponentContext();
        ctx.deactivateEndpoint(ep);
        super.deactivate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() != MessageExchange.Role.PROVIDER) throw new IllegalStateException("Unsupported role: " + exchange.getRole());
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (exchange.getFault() != null) {
            this.done(exchange);
            return;
        } else {
            NormalizedMessage in = exchange.getMessage("in");
            if (in == null) throw new IllegalStateException("Provider exchange is ACTIVE, but no in or fault is provided");
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                this.processInOnly(exchange, in);
                this.done(exchange);
                return;
            } else {
                boolean txSync;
                NormalizedMessage out = exchange.getMessage("out");
                if (out == null) {
                    out = exchange.createMessage();
                    exchange.setMessage(out, "out");
                }
                this.processInOut(exchange, in, out);
                boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
                if (txSync) {
                    this.sendSync(exchange);
                    return;
                } else {
                    this.send(exchange);
                }
            }
        }
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        throw new UnsupportedOperationException("Unsupported MEP: " + exchange.getPattern());
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        throw new UnsupportedOperationException("Unsupported MEP: " + exchange.getPattern());
    }
}

