/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.osgi.DeployedAssembly;
import org.apache.servicemix.common.osgi.EndpointWrapper;
import org.apache.servicemix.common.osgi.EndpointWrapperImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointExporter
implements BundleContextAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
DeployedAssembly {
    private final Logger logger = LoggerFactory.getLogger(EndpointExporter.class);
    private BundleContext bundleContext;
    private ApplicationContext applicationContext;
    private Collection<Endpoint> endpoints;
    private Set<Endpoint> deployed;
    private String assemblyName;
    private Collection<ServiceRegistration> endpointRegistrations;
    private ServiceRegistration assemblyRegistration;
    private Timer timer;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEndpoints(Collection<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public Collection<Endpoint> getEndpoints() {
        Collection<Endpoint> eps = this.endpoints;
        if (eps == null) {
            eps = this.applicationContext.getBeansOfType(Endpoint.class).values();
        }
        return eps;
    }

    @Override
    public String getName() {
        return this.assemblyName;
    }

    @Override
    public Map<String, String> getServiceUnits() {
        if (this.endpointRegistrations == null) {
            throw new IllegalStateException("Service assembly has not been deployed");
        }
        HashMap<String, String> sus = new HashMap<String, String>();
        for (Endpoint ep : this.getEndpoints()) {
            if (ep.getServiceUnit() == null) {
                throw new IllegalStateException("Endpoint has not been initialized.  Check that the component is installed.");
            }
            sus.put(ep.getServiceUnit().getName(), ep.getServiceUnit().getComponent().getComponentName());
        }
        return sus;
    }

    @Override
    public void undeploy(boolean restart) {
        if (this.endpointRegistrations != null) {
            for (ServiceRegistration reg : this.endpointRegistrations) {
                reg.unregister();
            }
            this.endpointRegistrations = null;
        }
        if (this.assemblyRegistration != null) {
            this.assemblyRegistration.unregister();
            this.assemblyRegistration = null;
        }
        if (restart) {
            this.deploy();
        }
    }

    public void deploy() {
        this.assemblyName = this.bundleContext.getBundle().getSymbolicName();
        this.endpointRegistrations = new ArrayList<ServiceRegistration>();
        this.deployed = new HashSet<Endpoint>();
        for (final Endpoint ep : this.getEndpoints()) {
            EndpointWrapperImpl wrapper = new EndpointWrapperImpl(ep, this.applicationContext.getClassLoader()){

                public void setDeployed() {
                    EndpointExporter.this.checkAndRegisterSA(ep);
                }
            };
            Properties props = new Properties();
            ServiceRegistration reg = this.bundleContext.registerService(EndpointWrapper.class.getName(), (Object)wrapper, (Dictionary)props);
            if (reg == null) continue;
            this.endpointRegistrations.add(reg);
        }
        if (this.assemblyRegistration == null) {
            this.logger.info("Waiting for all endpoints to be deployed before registering service assembly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void checkAndRegisterSA(Endpoint ep) {
        if (this.assemblyRegistration != null) {
            return;
        }
        if (!(ep == null || ep.getServiceUnit() != null && ep.getServiceUnit().getComponent().getRegistry().isRegistered(ep.getServiceUnit()))) {
            this.logger.info("something wrong during register endpoint {}", (Object)ep.getKey());
            for (Endpoint e : this.deployed) {
                e.getServiceUnit().getComponent().getRegistry().unregisterServiceUnit(e.getServiceUnit());
            }
            return;
        }
        if (ep != null) {
            this.deployed.add(ep);
        }
        Collection<Endpoint> endpoints = this.getEndpoints();
        if (this.deployed.size() == endpoints.size()) {
            boolean initialized = true;
            for (Endpoint e : endpoints) {
                if (e.getServiceUnit().getComponent().getComponentContext() != null) continue;
                initialized = false;
                break;
            }
            if (!initialized) {
                if (this.timer == null) {
                    this.timer = new Timer();
                    this.logger.info("All endpoints have been deployed but waiting for components initialization");
                }
                EndpointExporter endpointExporter = this;
                synchronized (endpointExporter) {
                    this.timer.schedule(new TimerTask(){

                        public void run() {
                            EndpointExporter.this.checkAndRegisterSA(null);
                        }
                    }, 500L);
                }
            } else {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.logger.info("All endpoints have been deployed and components initialized. Registering service assembly.");
                this.assemblyRegistration = this.bundleContext.registerService(DeployedAssembly.class.getName(), (Object)this, (Dictionary)new Properties());
            }
        }
    }

    public void afterPropertiesSet() {
        this.deploy();
    }

    public void destroy() throws Exception {
    }
}

