/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.SMIAddress;

public class IpAddress
extends SMIAddress {
    private static final long serialVersionUID = -146846354059565449L;
    private static final LogAdapter logger = LogFactory.getLogger(AbstractVariable.class);
    private static final byte[] IPANYADDRESS = new byte[]{0, 0, 0, 0};
    public static final InetAddress ANY_IPADDRESS = IpAddress.createAnyAddress();
    private InetAddress inetAddress;

    public IpAddress() {
        this.inetAddress = ANY_IPADDRESS;
    }

    public IpAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        this.inetAddress = inetAddress;
    }

    public IpAddress(String string) {
        if (!this.parseAddress(string)) {
            throw new IllegalArgumentException(string);
        }
    }

    public int getSyntax() {
        return 64;
    }

    public boolean isValid() {
        return this.inetAddress != null;
    }

    public String toString() {
        String string = this.inetAddress.toString();
        return string.substring(string.indexOf(47) + 1);
    }

    public int hashCode() {
        if (this.inetAddress != null) {
            return this.inetAddress.hashCode();
        }
        return 0;
    }

    public static Address parse(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return new IpAddress(inetAddress);
        }
        catch (Exception exception) {
            logger.error("Unable to parse IpAddress from: " + string, exception);
            return null;
        }
    }

    public boolean parseAddress(String string) {
        try {
            this.inetAddress = InetAddress.getByName(string);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public int compareTo(Object object) {
        OctetString octetString = new OctetString(this.inetAddress.getAddress());
        return octetString.compareTo(new OctetString(((IpAddress)object).getInetAddress().getAddress()));
    }

    public boolean equals(Object object) {
        if (!(object instanceof IpAddress)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        byte[] byArray = BER.decodeString(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 64) {
            throw new IOException("Wrong type encountered when decoding Counter: " + mutableByte.getValue());
        }
        if (byArray.length != 4) {
            throw new IOException("IpAddress encoding error, wrong length: " + byArray.length);
        }
        this.inetAddress = InetAddress.getByAddress(byArray);
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4];
        System.arraycopy(this.inetAddress.getAddress(), 0, byArray, 0, 4);
        BER.encodeString(outputStream, (byte)64, this.inetAddress.getAddress());
    }

    public int getBERLength() {
        return 6;
    }

    public void setAddress(byte[] byArray) throws UnknownHostException {
        this.inetAddress = InetAddress.getByAddress(byArray);
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    private static InetAddress createAnyAddress() {
        try {
            return InetAddress.getByAddress(IPANYADDRESS);
        }
        catch (Exception exception) {
            logger.error("Unable to create any IpAddress: " + exception.getMessage(), exception);
            return null;
        }
    }

    public Object clone() {
        return new IpAddress(this.inetAddress);
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public OID toSubIndex(boolean bl) {
        byte[] byArray = new byte[4];
        System.arraycopy(this.inetAddress.getAddress(), 0, byArray, 0, 4);
        OID oID = new OID(new int[4]);
        for (int i = 0; i < byArray.length; ++i) {
            oID.set(i, byArray[i] & 0xFF);
        }
        return oID;
    }

    public void fromSubIndex(OID oID, boolean bl) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(oID.get(i) & 0xFF);
        }
        try {
            this.setAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    public void setValue(String string) {
        if (!this.parseAddress(string)) {
            throw new IllegalArgumentException(string + " cannot be parsed by " + this.getClass().getName());
        }
    }
}

