/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.TransportMapping;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.util.ThreadPool;

public class MultiThreadedMessageDispatcher
implements MessageDispatcher {
    private MessageDispatcher dispatcher;
    private ThreadPool threadPool;

    public MultiThreadedMessageDispatcher(ThreadPool threadPool, MessageDispatcher messageDispatcher) {
        this.threadPool = threadPool;
        this.dispatcher = messageDispatcher;
    }

    public int getNextRequestID() {
        return this.dispatcher.getNextRequestID();
    }

    public void addMessageProcessingModel(MessageProcessingModel messageProcessingModel) {
        this.dispatcher.addMessageProcessingModel(messageProcessingModel);
    }

    public void removeMessageProcessingModel(MessageProcessingModel messageProcessingModel) {
        this.dispatcher.removeMessageProcessingModel(messageProcessingModel);
    }

    public MessageProcessingModel getMessageProcessingModel(int n) {
        return this.dispatcher.getMessageProcessingModel(n);
    }

    public void addTransportMapping(TransportMapping transportMapping) {
        this.dispatcher.addTransportMapping(transportMapping);
    }

    public TransportMapping removeTransportMapping(TransportMapping transportMapping) {
        return this.dispatcher.removeTransportMapping(transportMapping);
    }

    public Collection getTransportMappings() {
        return this.dispatcher.getTransportMappings();
    }

    public void addCommandResponder(CommandResponder commandResponder) {
        this.dispatcher.addCommandResponder(commandResponder);
    }

    public void removeCommandResponder(CommandResponder commandResponder) {
        this.dispatcher.removeCommandResponder(commandResponder);
    }

    public PduHandle sendPdu(Address address, int n, int n2, byte[] byArray, int n3, PDU pDU, boolean bl) throws MessageException {
        return this.dispatcher.sendPdu(address, n, n2, byArray, n3, pDU, bl);
    }

    public PduHandle sendPdu(TransportMapping transportMapping, Address address, int n, int n2, byte[] byArray, int n3, PDU pDU, boolean bl) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, address, n, n2, byArray, n3, pDU, bl);
    }

    public PduHandle sendPdu(TransportMapping transportMapping, Address address, int n, int n2, byte[] byArray, int n3, PDU pDU, boolean bl, PduHandleCallback pduHandleCallback) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, address, n, n2, byArray, n3, pDU, bl, pduHandleCallback);
    }

    public int returnResponsePdu(int n, int n2, byte[] byArray, int n3, PDU pDU, int n4, StateReference stateReference, StatusInformation statusInformation) throws MessageException {
        return this.dispatcher.returnResponsePdu(n, n2, byArray, n3, pDU, n4, stateReference, statusInformation);
    }

    public void processMessage(TransportMapping transportMapping, Address address, BERInputStream bERInputStream) {
        MessageTask messageTask = new MessageTask(transportMapping, address, bERInputStream);
        this.threadPool.execute(messageTask);
    }

    public void processMessage(TransportMapping transportMapping, Address address, ByteBuffer byteBuffer) {
        this.processMessage(transportMapping, address, new BERInputStream(byteBuffer));
    }

    public void releaseStateReference(int n, PduHandle pduHandle) {
        this.dispatcher.releaseStateReference(n, pduHandle);
    }

    public TransportMapping getTransport(Address address) {
        return this.dispatcher.getTransport(address);
    }

    class MessageTask
    implements Runnable {
        private TransportMapping sourceTransport;
        private Address incomingAddress;
        private BERInputStream wholeMessage;

        public MessageTask(TransportMapping transportMapping, Address address, BERInputStream bERInputStream) {
            this.sourceTransport = transportMapping;
            this.incomingAddress = address;
            this.wholeMessage = bERInputStream;
        }

        public void run() {
            MultiThreadedMessageDispatcher.this.dispatcher.processMessage(this.sourceTransport, this.incomingAddress, this.wholeMessage);
        }
    }
}

