/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.util.Arrays;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.OptionalParameter;

public class AbstractSmCommand
extends Command {
    protected String serviceType;
    protected byte sourceAddrTon;
    protected byte sourceAddrNpi;
    protected String sourceAddr;
    protected byte destAddrTon;
    protected byte destAddrNpi;
    protected String destAddress;
    protected byte esmClass;
    protected byte registeredDelivery;
    protected byte dataCoding;
    protected OptionalParameter[] optionalParametes;

    public boolean isDefaultMessageType() {
        return AbstractSmCommand.isDefaultMessageType(this.esmClass);
    }

    public void setDefaultMessageType() {
        this.esmClass = AbstractSmCommand.composeDefaultMessageType(this.esmClass);
    }

    public boolean isUdhi() {
        return AbstractSmCommand.isUdhi(this.esmClass);
    }

    public void setUdhi() {
        this.esmClass = AbstractSmCommand.composeUdhi(this.esmClass);
    }

    public boolean isReplyPath() {
        return AbstractSmCommand.isReplyPath(this.esmClass);
    }

    public void setReplyPath() {
        this.esmClass = AbstractSmCommand.composeReplyPath(this.esmClass);
    }

    public boolean isUdhiAndReplyPath() {
        return AbstractSmCommand.isUdhiAndReplyPath(this.esmClass);
    }

    public void setUdhiAndReplyPath() {
        this.esmClass = AbstractSmCommand.composeUdhiAndReplyPath(this.esmClass);
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(byte dataCoding) {
        this.dataCoding = dataCoding;
    }

    public byte getDestAddrTon() {
        return this.destAddrTon;
    }

    public void setDestAddrTon(byte destAddrTon) {
        this.destAddrTon = destAddrTon;
    }

    public byte getDestAddrNpi() {
        return this.destAddrNpi;
    }

    public void setDestAddrNpi(byte destAddrNpi) {
        this.destAddrNpi = destAddrNpi;
    }

    public String getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(String destAddress) {
        this.destAddress = destAddress;
    }

    public byte getEsmClass() {
        return this.esmClass;
    }

    public void setEsmClass(byte esmClass) {
        this.esmClass = esmClass;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public OptionalParameter[] getOptionalParametes() {
        return this.optionalParametes;
    }

    public void setOptionalParametes(OptionalParameter ... optionalParametes) {
        this.optionalParametes = optionalParametes;
    }

    public byte getSourceAddrTon() {
        return this.sourceAddrTon;
    }

    public void setSourceAddrTon(byte sourceAddrTon) {
        this.sourceAddrTon = sourceAddrTon;
    }

    public byte getSourceAddrNpi() {
        return this.sourceAddrNpi;
    }

    public void setSourceAddrNpi(byte sourceAddrNpi) {
        this.sourceAddrNpi = sourceAddrNpi;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public static boolean isDefaultMessageType(byte esmClass) {
        return AbstractSmCommand.isMessageType(esmClass, (byte)0);
    }

    public static byte composeDefaultMessageType(byte esmClass) {
        return AbstractSmCommand.cleanMessageType(esmClass);
    }

    public static boolean isUdhi(byte esmClass) {
        return AbstractSmCommand.isSpecificFeatures(esmClass, (byte)64);
    }

    public static byte composeUdhi(byte esmClass) {
        return AbstractSmCommand.composeSpecificFeatures(esmClass, (byte)64);
    }

    public static boolean isReplyPath(byte esmClass) {
        return AbstractSmCommand.isSpecificFeatures(esmClass, (byte)-128);
    }

    public static byte composeReplyPath(byte esmClass) {
        return AbstractSmCommand.composeSpecificFeatures(esmClass, (byte)-128);
    }

    public static boolean isUdhiAndReplyPath(byte esmClass) {
        return AbstractSmCommand.isSpecificFeatures(esmClass, (byte)-64);
    }

    public static byte composeUdhiAndReplyPath(byte esmClass) {
        return AbstractSmCommand.composeSpecificFeatures(esmClass, (byte)-64);
    }

    protected static final boolean isMessagingMode(byte esmClass, byte messagingModeValue) {
        return (esmClass & 3) == messagingModeValue;
    }

    protected static final byte composeMessagingMode(byte esmClass, byte messagingModeValue) {
        return (byte)(AbstractSmCommand.cleanMessagingMode(esmClass) | messagingModeValue);
    }

    protected static final byte cleanMessagingMode(byte esmClass) {
        return (byte)(esmClass & 3);
    }

    protected static final boolean isMessageType(byte esmClass, byte messageTypeValue) {
        return (esmClass & 0x3C) == messageTypeValue;
    }

    protected static final byte composeMessageType(byte esmClass, byte messageTypeValue) {
        return (byte)(AbstractSmCommand.cleanMessageType(esmClass) | messageTypeValue);
    }

    protected static final byte cleanMessageType(byte esmClass) {
        return (byte)(esmClass & 0xC3);
    }

    protected static final boolean isSpecificFeatures(byte esmClass, byte specificFeaturesValue) {
        return (esmClass & 0xC0) == specificFeaturesValue;
    }

    protected static final byte composeSpecificFeatures(byte esmClass, byte specificFeaturesValue) {
        return (byte)(AbstractSmCommand.cleanSpecificFeatures(esmClass) | specificFeaturesValue);
    }

    protected static final byte cleanSpecificFeatures(byte esmClass) {
        return (byte)(esmClass & 0x3F);
    }

    protected static final boolean isSmscDeliveryReceipt(byte registeredDelivery, byte smscDeliveryReceiptValue) {
        return (registeredDelivery & 3) == smscDeliveryReceiptValue;
    }

    protected static final byte composeSmscDelReceipt(byte registeredDelivery, byte smscDeliveryReceiptValue) {
        return (byte)(AbstractSmCommand.cleanSmscDeliveryReceipt(registeredDelivery) | smscDeliveryReceiptValue);
    }

    protected static final byte cleanSmscDeliveryReceipt(byte registeredDelivery) {
        return (byte)(registeredDelivery & 0xFC);
    }

    protected static final boolean isSmeAck(byte registeredDeliery, byte smeOriginatedAckValue) {
        return (registeredDeliery & 0xC) == smeOriginatedAckValue;
    }

    protected static final byte composeSmeAck(byte registeredDelivery, byte smeOriginatedValue) {
        return (byte)(AbstractSmCommand.cleanSmeAck(registeredDelivery) | smeOriginatedValue);
    }

    protected static final byte cleanSmeAck(byte registeredDelivery) {
        return (byte)(registeredDelivery & 0xC);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.destAddress == null ? 0 : this.destAddress.hashCode());
        result = 31 * result + Arrays.hashCode(this.optionalParametes);
        result = 31 * result + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = 31 * result + (this.sourceAddr == null ? 0 : this.sourceAddr.hashCode());
        return result;
    }

    private boolean hasEqualDestAddress(AbstractSmCommand other) {
        if (this.destAddress == null && other.destAddress != null) {
            return false;
        }
        return this.destAddress.equals(other.destAddress);
    }

    private boolean hasEqualSourceAddr(AbstractSmCommand other) {
        if (this.sourceAddr == null && other.sourceAddr != null) {
            return false;
        }
        return this.sourceAddr.equals(other.sourceAddr);
    }

    private boolean hasEqualServiceType(AbstractSmCommand other) {
        if (this.serviceType == null && other.serviceType != null) {
            return false;
        }
        return this.serviceType.equals(other.serviceType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSmCommand other = (AbstractSmCommand)obj;
        if (this.destAddrTon != other.destAddrTon) {
            return false;
        }
        if (this.destAddrNpi != other.destAddrNpi) {
            return false;
        }
        if (!this.hasEqualDestAddress(other)) {
            return false;
        }
        if (this.sourceAddrTon != other.sourceAddrTon) {
            return false;
        }
        if (this.sourceAddrNpi != other.sourceAddrNpi) {
            return false;
        }
        if (!this.hasEqualSourceAddr(other)) {
            return false;
        }
        if (this.dataCoding != other.dataCoding) {
            return false;
        }
        if (this.esmClass != other.esmClass) {
            return false;
        }
        if (!Arrays.equals(this.optionalParametes, other.optionalParametes)) {
            return false;
        }
        if (this.registeredDelivery != other.registeredDelivery) {
            return false;
        }
        return this.hasEqualServiceType(other);
    }
}

