/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataCodingTest {
    @Test(groups={"checkintest"})
    public void testGeneralDataCoding() {
        GeneralDataCoding dataCoding = new GeneralDataCoding();
        dataCoding.setCompressed(true);
        Assert.assertTrue((boolean)dataCoding.isCompressed());
        dataCoding.setCompressed(false);
        Assert.assertFalse((boolean)dataCoding.isCompressed());
        dataCoding.setContainMessageClass(true);
        Assert.assertTrue((boolean)dataCoding.isContainMessageClass());
        dataCoding.setContainMessageClass(false);
        Assert.assertFalse((boolean)dataCoding.isContainMessageClass());
        dataCoding.setContainMessageClass(true);
        dataCoding.setMessageClass(MessageClass.CLASS0);
        Assert.assertEquals((Object)((Object)dataCoding.getMessageClass()), (Object)((Object)MessageClass.CLASS0));
        dataCoding.setMessageClass(MessageClass.CLASS1);
        Assert.assertEquals((Object)((Object)dataCoding.getMessageClass()), (Object)((Object)MessageClass.CLASS1));
        dataCoding.setMessageClass(MessageClass.CLASS2);
        Assert.assertEquals((Object)((Object)dataCoding.getMessageClass()), (Object)((Object)MessageClass.CLASS2));
        dataCoding.setMessageClass(MessageClass.CLASS3);
        Assert.assertEquals((Object)((Object)dataCoding.getMessageClass()), (Object)((Object)MessageClass.CLASS3));
        dataCoding.setAlphabet(Alphabet.ALPHA_DEFAULT);
        Assert.assertEquals((Object)((Object)dataCoding.getAlphabet()), (Object)((Object)Alphabet.ALPHA_DEFAULT));
        dataCoding.setAlphabet(Alphabet.ALPHA_8_BIT);
        Assert.assertEquals((Object)((Object)dataCoding.getAlphabet()), (Object)((Object)Alphabet.ALPHA_8_BIT));
        dataCoding.setAlphabet(Alphabet.ALPHA_UCS2);
        Assert.assertEquals((Object)((Object)dataCoding.getAlphabet()), (Object)((Object)Alphabet.ALPHA_UCS2));
        dataCoding.setAlphabet(Alphabet.ALPHA_RESERVED);
        Assert.assertEquals((Object)((Object)dataCoding.getAlphabet()), (Object)((Object)Alphabet.ALPHA_RESERVED));
        Assert.assertTrue((boolean)GeneralDataCoding.isCompatible(dataCoding.value()));
        Assert.assertFalse((boolean)GeneralDataCoding.isCompatible((byte)-1));
    }

    @Test(groups={"checkintest"})
    public void testDataCoding0x1() {
        byte value = 17;
        DataCoding dataCoding = DataCoding.newInstance(value);
        Assert.assertTrue((boolean)(dataCoding instanceof GeneralDataCoding));
        GeneralDataCoding coding = (GeneralDataCoding)dataCoding;
        Assert.assertFalse((boolean)coding.isCompressed());
        Assert.assertTrue((boolean)coding.isContainMessageClass());
        Assert.assertEquals((Object)((Object)coding.getAlphabet()), (Object)((Object)Alphabet.ALPHA_DEFAULT));
        Assert.assertEquals((Object)((Object)coding.getMessageClass()), (Object)((Object)MessageClass.CLASS1));
    }
}

