/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.BasicConfigurator;
import org.jsmpp.PDUStringException;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;

public class AcceptingConnectionAndBindExample {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            System.out.println("Listening ...");
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(8056);
            SMPPServerSession session = sessionListener.accept();
            System.out.println("Accept connection");
            try {
                BindRequest request = session.waitForBind(5000L);
                System.out.println("Receive bind request");
                if (request.getBindParameter().getSystemId().equals("test") && request.getBindParameter().getPassword().equals("test")) {
                    System.out.println("Accepting bind request");
                    request.accept("sys");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    System.out.println("Rejecting bind request");
                    request.reject(14);
                }
            }
            catch (TimeoutException e) {
                System.out.println("No binding request made after 5000 millisecond");
                e.printStackTrace();
            }
            if (session.getSessionState().isBound()) {
                System.out.println("Closing session");
                session.unbindAndClose();
            }
            System.out.println("Closing session listener");
            sessionListener.close();
        }
        catch (PDUStringException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

