/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.OptionalParameters;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;

public class SubmitLongMessageExample {
    private static TimeFormatter timeFormatter = new AbsoluteTimeFormatter();

    public static void main(String[] args) {
        SMPPSession session = new SMPPSession();
        try {
            session.connectAndBind("localhost", 8056, new BindParameter(BindType.BIND_TX, "test", "test", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
        }
        catch (IOException e) {
            System.err.println("Failed connect and bind to host");
            e.printStackTrace();
        }
        Random random = new Random();
        int totalSegments = 3;
        OptionalParameter.Short sarMsgRefNum = OptionalParameters.newSarMsgRefNum((short)random.nextInt());
        OptionalParameter.Byte sarTotalSegments = OptionalParameters.newSarTotalSegments(3);
        int i = 0;
        while (i < 3) {
            int seqNum = i + 1;
            String message = "Message part " + seqNum + " of " + 3 + " ";
            OptionalParameter.Byte sarSegmentSeqnum = OptionalParameters.newSarSegmentSeqnum(seqNum);
            String messageId = SubmitLongMessageExample.submitMessage(session, message, sarMsgRefNum, sarSegmentSeqnum, sarTotalSegments);
            System.out.println("Message submitted, message_id is " + messageId);
            ++i;
        }
        session.unbindAndClose();
    }

    public static String submitMessage(SMPPSession session, String message, OptionalParameter sarMsgRefNum, OptionalParameter sarSegmentSeqnum, OptionalParameter sarTotalSegments) {
        String messageId = null;
        try {
            messageId = session.submitShortMessage("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "1616", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504657", new ESMClass(), (byte)0, (byte)1, timeFormatter.format(new Date()), null, new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT), (byte)0, new GeneralDataCoding(false, true, MessageClass.CLASS1, Alphabet.ALPHA_DEFAULT), (byte)0, message.getBytes(), sarMsgRefNum, sarSegmentSeqnum, sarTotalSegments);
        }
        catch (PDUException e) {
            System.err.println("Invalid PDU parameter");
            e.printStackTrace();
        }
        catch (ResponseTimeoutException e) {
            System.err.println("Response timeout");
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            System.err.println("Receive invalid respose");
            e.printStackTrace();
        }
        catch (NegativeResponseException e) {
            System.err.println("Receive negative response");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IO error occur");
            e.printStackTrace();
        }
        return messageId;
    }
}

