/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUSender;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DataSmResp;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.DataSmCommandTask;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.EnquireLinkCommandTask;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.SendCommandTask;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.UnbindCommandTask;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.util.IntUtil;
import org.jsmpp.util.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSession.class);
    private static final Random random = new Random();
    private final Map<Integer, PendingResponse<Command>> pendingResponse = new ConcurrentHashMap<Integer, PendingResponse<Command>>();
    private final Sequence sequence = new Sequence(1);
    private final PDUSender pduSender;
    private int pduProcessorDegree = 3;
    private String sessionId = AbstractSession.generateSessionId();
    private int enquireLinkTimer = 5000;
    private long transactionTimer = 2000L;

    public AbstractSession(PDUSender pduSender) {
        this.pduSender = pduSender;
    }

    protected abstract AbstractSessionContext sessionContext();

    protected abstract Connection connection();

    protected abstract GenericMessageReceiverListener messageReceiverListener();

    protected PDUSender pduSender() {
        return this.pduSender;
    }

    protected Sequence sequence() {
        return this.sequence;
    }

    protected PendingResponse<Command> removePendingResponse(int sequenceNumber) {
        return this.pendingResponse.remove(sequenceNumber);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setEnquireLinkTimer(int enquireLinkTimer) {
        if (this.sessionContext().getSessionState().isBound()) {
            try {
                this.connection().setSoTimeout(enquireLinkTimer);
            }
            catch (IOException e) {
                logger.error("Failed setting so_timeout for session timer", (Throwable)e);
            }
        }
        this.enquireLinkTimer = enquireLinkTimer;
    }

    @Override
    public int getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    @Override
    public void setTransactionTimer(long transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    @Override
    public long getTransactionTimer() {
        return this.transactionTimer;
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionContext().getSessionState();
    }

    @Override
    public void addSessionStateListener(SessionStateListener l) {
        if (l != null) {
            this.sessionContext().addSessionStateListener(l);
        }
    }

    @Override
    public void removeSessionStateListener(SessionStateListener l) {
        this.sessionContext().removeSessionStateListener(l);
    }

    @Override
    public long getLastActivityTimestamp() {
        return this.sessionContext().getLastActivityTimestamp();
    }

    public void setPduProcessorDegree(int pduProcessorDegree) throws IllegalStateException {
        if (!this.getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IllegalStateException("Cannot set pdu processor degree since the pdu dispatcher thread already created.");
        }
        this.pduProcessorDegree = pduProcessorDegree;
    }

    public int getPduProcessorDegree() {
        return this.pduProcessorDegree;
    }

    @Override
    public DataSmResult dataShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, RegisteredDelivery registeredDelivery, DataCoding dataCoding, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        DataSmCommandTask task = new DataSmCommandTask(this.pduSender, serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, registeredDelivery, dataCoding, optionalParameters);
        DataSmResp resp = (DataSmResp)this.executeSendCommand(task, this.getTransactionTimer());
        return new DataSmResult(resp.getMessageId(), resp.getOptionalParameters());
    }

    @Override
    public void close() {
        AbstractSessionContext ctx = this.sessionContext();
        if (!ctx.getSessionState().equals((Object)SessionState.CLOSED)) {
            ctx.close();
            try {
                this.connection().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void validateResponse(Command response) throws NegativeResponseException {
        if (response.getCommandStatus() != 0) {
            throw new NegativeResponseException(response.getCommandStatus());
        }
    }

    protected DataSmResult fireAcceptDataSm(DataSm dataSm) throws ProcessRequestException {
        GenericMessageReceiverListener messageReceiverListener = this.messageReceiverListener();
        if (messageReceiverListener != null) {
            return messageReceiverListener.onAcceptDataSm(dataSm, this);
        }
        throw new ProcessRequestException("MessageReceveiverListener hasn't been set yet", 102);
    }

    protected Command executeSendCommand(SendCommandTask task, long timeout) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        int seqNum = this.sequence.nextValue();
        PendingResponse pendingResp = new PendingResponse(timeout);
        this.pendingResponse.put(seqNum, pendingResp);
        try {
            task.executeTask(this.connection().getOutputStream(), seqNum);
        }
        catch (IOException e) {
            logger.error("Failed sending " + task.getCommandName() + " command", (Throwable)e);
            this.pendingResponse.remove(seqNum);
            this.close();
            throw e;
        }
        try {
            pendingResp.waitDone();
            logger.debug(String.valueOf(task.getCommandName()) + " response received");
        }
        catch (ResponseTimeoutException e) {
            this.pendingResponse.remove(seqNum);
            throw new ResponseTimeoutException("No response after waiting for " + timeout + " millis when executing " + task.getCommandName() + " with sessionId " + this.sessionId + " and sequenceNumber " + seqNum, e);
        }
        catch (InvalidResponseException e) {
            this.pendingResponse.remove(seqNum);
            throw e;
        }
        Object resp = pendingResp.getResponse();
        AbstractSession.validateResponse(resp);
        return resp;
    }

    private static final synchronized String generateSessionId() {
        return IntUtil.toHexString(random.nextInt());
    }

    protected void sendEnquireLink() throws ResponseTimeoutException, InvalidResponseException, IOException {
        EnquireLinkCommandTask task = new EnquireLinkCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.getTransactionTimer());
        }
        catch (PDUException e) {
            logger.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            logger.warn("command_status of response should be always 0", (Throwable)e);
        }
    }

    private void unbind() throws ResponseTimeoutException, InvalidResponseException, IOException {
        if (this.sessionContext().getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IOException("Session is closed");
        }
        UnbindCommandTask task = new UnbindCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.transactionTimer);
        }
        catch (PDUException e) {
            logger.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            logger.warn("Receive non-ok command_status (" + e.getCommandStatus() + ") for unbind_resp");
        }
    }

    @Override
    public void unbindAndClose() {
        if (this.sessionContext().getSessionState().isBound()) {
            try {
                this.unbind();
            }
            catch (ResponseTimeoutException e) {
                logger.error("Timeout waiting unbind response", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                logger.error("Receive invalid unbind response", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("IO error found ", (Throwable)e);
            }
        }
        this.close();
    }
}

