/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.concurrent.TimeoutException;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.BindType;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.BindRequestReceiver;
import org.jsmpp.session.DummyResponseHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BindRequestReceiverTest {
    private BindRequestReceiver requestReceiver;

    @BeforeMethod
    public void setUp() {
        this.requestReceiver = new BindRequestReceiver(new DummyResponseHandler());
    }

    @Test(groups={"checkintest"})
    public void testWaitTimeout() {
        try {
            BindRequest request = this.requestReceiver.waitForRequest(1000L);
            Assert.fail((String)"Should fail since no request for 1000 millis");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not fail waitForRequest");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test(groups={"checkintest"})
    public void testReceiveRequest() {
        try {
            this.requestReceiver.notifyAcceptBind(BindRequestReceiverTest.dummyBind());
            BindRequest request = this.requestReceiver.waitForRequest(1000L);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not fail waitForRequest and success accepting request");
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Should not fail waitForRequest and success accepting request");
        }
        try {
            this.requestReceiver.notifyAcceptBind(BindRequestReceiverTest.dummyBind());
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.requestReceiver.waitForRequest(1000L);
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Should throw IllegalStateException");
        }
    }

    @Test(groups={"checkintest"})
    public void testNoSingleAccept() {
        try {
            this.requestReceiver.notifyAcceptBind(BindRequestReceiverTest.dummyBind());
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not fail waitForRequest and success accepting request");
        }
        try {
            this.requestReceiver.notifyAcceptBind(BindRequestReceiverTest.dummyBind());
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(groups={"checkintest"})
    public void testNonSingleWait() {
        try {
            BindRequest request = this.requestReceiver.waitForRequest(1000L);
            Assert.fail((String)"Should throw TimeoutException");
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should throw TimeoutException");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        try {
            this.requestReceiver.waitForRequest(1000L);
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Should throw IllegalStateException");
        }
    }

    private static final Bind dummyBind() {
        Bind bind = new Bind();
        bind.setCommandId(BindType.BIND_RX.commandId());
        return bind;
    }
}

