/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.bean.Command;
import org.jsmpp.session.ActivityNotifier;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.state.SMPPSessionState;

public class PDUProcessTask
implements Runnable {
    private final Command pduHeader;
    private final byte[] pdu;
    private final SMPPSessionState stateProcessor;
    private final ResponseHandler responseHandler;
    private final ActivityNotifier activityNotifier;
    private final Runnable onIOExceptionTask;

    public PDUProcessTask(Command pduHeader, byte[] pdu, SMPPSessionState stateProcessor, ResponseHandler responseHandler, ActivityNotifier activityNotifier, Runnable onIOExceptionTask) {
        this.pduHeader = pduHeader;
        this.pdu = pdu;
        this.stateProcessor = stateProcessor;
        this.responseHandler = responseHandler;
        this.activityNotifier = activityNotifier;
        this.onIOExceptionTask = onIOExceptionTask;
    }

    public void run() {
        try {
            switch (this.pduHeader.getCommandId()) {
                case -2147483647: 
                case -2147483646: 
                case -2147483639: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processBindResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483648: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processGenericNack(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 21: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processEnquireLink(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483627: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processEnquireLinkResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483644: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processSubmitSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483615: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processSubmitMultiResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483645: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processQuerySmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 5: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processDeliverSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 259: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processDataSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483389: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processDataSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483640: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processCancelSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483641: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processReplaceSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 258: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processAlertNotification(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 6: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processUnbind(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483642: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processUnbindResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                default: {
                    this.stateProcessor.processUnknownCid(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.onIOExceptionTask.run();
        }
    }
}

