/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.state.SMPPServerSessionState;

public class SMPPServerSessionContext
extends AbstractSessionContext {
    private SMPPServerSessionState stateProcessor = SMPPServerSessionState.CLOSED;
    private final SMPPServerSession smppServerSession;

    public SMPPServerSessionContext(SMPPServerSession smppServerSession) {
        this.smppServerSession = smppServerSession;
    }

    protected void changeState(SessionState newState) {
        if (!this.stateProcessor.getSessionState().equals((Object)newState)) {
            SessionState oldState = this.stateProcessor.getSessionState();
            if (newState == SessionState.OPEN) {
                this.stateProcessor = SMPPServerSessionState.OPEN;
            } else if (newState == SessionState.BOUND_RX) {
                this.stateProcessor = SMPPServerSessionState.BOUND_RX;
            } else if (newState == SessionState.BOUND_TX) {
                this.stateProcessor = SMPPServerSessionState.BOUND_TX;
            } else if (newState == SessionState.BOUND_TRX) {
                this.stateProcessor = SMPPServerSessionState.BOUND_TRX;
            } else if (newState == SessionState.UNBOUND) {
                this.stateProcessor = SMPPServerSessionState.UNBOUND;
            } else if (newState == SessionState.CLOSED) {
                this.stateProcessor = SMPPServerSessionState.CLOSED;
            }
            this.fireStateChanged(newState, oldState, this.smppServerSession);
        }
    }

    public synchronized SMPPServerSessionState getStateProcessor() {
        return this.stateProcessor;
    }

    public synchronized SessionState getSessionState() {
        return this.stateProcessor.getSessionState();
    }
}

