/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.util.Calendar;
import java.util.Date;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.RelativeTimeFormatter;
import org.jsmpp.util.StringParameter;
import org.jsmpp.util.StringValidator;
import org.jsmpp.util.TimeFormatter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DateFormatterTest {
    @Test(groups={"checkintest"})
    public void testStaticAbsoluteFormatter() {
        String formatted = AbsoluteTimeFormatter.format(7, 12, 26, 11, 37, 3, 8, 45, Character.valueOf('+'));
        Assert.assertEquals((String)formatted, (String)"071226113703845+");
    }

    @Test(groups={"checkintest"})
    public void testStaticRelativeFormatter() {
        String formatted = RelativeTimeFormatter.format(7, 12, 26, 12, 46, 10);
        Assert.assertEquals((String)formatted, (String)"071226124610000R");
    }

    @Test(groups={"checkintest"})
    public void formatNullDate() {
        TimeFormatter timeFormatter = new AbsoluteTimeFormatter();
        Assert.assertNull((Object)timeFormatter.format((Date)null));
        Assert.assertNull((Object)timeFormatter.format((Calendar)null));
        timeFormatter = new RelativeTimeFormatter();
        Assert.assertNull((Object)timeFormatter.format((Date)null));
        Assert.assertNull((Object)timeFormatter.format((Calendar)null));
    }

    @Test(groups={"checkintest"})
    public void validateAbsoluteDate() throws Exception {
        String formatted = AbsoluteTimeFormatter.format(7, 12, 26, 11, 37, 3, 8, 45, Character.valueOf('+'));
        StringValidator.validateString(formatted, StringParameter.SCHEDULE_DELIVERY_TIME);
        StringValidator.validateString(formatted, StringParameter.VALIDITY_PERIOD);
        StringValidator.validateString(formatted, StringParameter.FINAL_DATE);
    }

    @Test(groups={"checkintest"})
    public void validateRelativeDate() throws Exception {
        String formatted = RelativeTimeFormatter.format(7, 12, 26, 12, 46, 10);
        StringValidator.validateString(formatted, StringParameter.SCHEDULE_DELIVERY_TIME);
        StringValidator.validateString(formatted, StringParameter.VALIDITY_PERIOD);
        StringValidator.validateString(formatted, StringParameter.FINAL_DATE);
    }
}

