/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.util.Calendar;
import java.util.Date;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.InvalidDeliveryReceiptException;
import org.jsmpp.util.PDUDecomposer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DeliveryReceiptParserTest {
    private PDUDecomposer decomposer = new DefaultDecomposer();
    private static final String ORIGINAL_MESSAGE = "testing jsmpp bow";

    @Test
    public void parseTextWithLowerCase() {
        try {
            DeliveryReceipt delReceipt = this.decomposer.deliveryReceipt("id:0123456789 sub:001 dlvrd:001 submit date:0809011130 done date:0809011131 stat:DELIVRD err:000 text:testing jsmpp bow");
            Assert.assertEquals((String)delReceipt.getText(), (String)ORIGINAL_MESSAGE);
            Date submitDate = delReceipt.getSubmitDate();
            Date expectedSubmitDate = DeliveryReceiptParserTest.createDate(2008, 9, 1, 11, 30);
            Assert.assertEquals((Object)submitDate, (Object)expectedSubmitDate);
            Date doneDate = delReceipt.getDoneDate();
            Date expectedDoneDate = DeliveryReceiptParserTest.createDate(2008, 9, 1, 11, 31);
            Assert.assertEquals((Object)doneDate, (Object)expectedDoneDate);
        }
        catch (InvalidDeliveryReceiptException e) {
            Assert.fail((String)("Failed parsing delivery receipt:" + e.getMessage()));
        }
    }

    @Test
    public void parsingTextWithUpperCase() {
        try {
            DeliveryReceipt delReceipt = this.decomposer.deliveryReceipt("id:0123456789 sub:001 dlvrd:001 submit date:0809011130 done date:0809011131 stat:DELIVRD err:000 Text:testing jsmpp bow");
            Assert.assertEquals((String)delReceipt.getText(), (String)ORIGINAL_MESSAGE);
            Date submitDate = delReceipt.getSubmitDate();
            Date expectedSubmitDate = DeliveryReceiptParserTest.createDate(2008, 9, 1, 11, 30);
            Assert.assertEquals((Object)submitDate, (Object)expectedSubmitDate);
            Date doneDate = delReceipt.getDoneDate();
            Date expectedDoneDate = DeliveryReceiptParserTest.createDate(2008, 9, 1, 11, 31);
            Assert.assertEquals((Object)doneDate, (Object)expectedDoneDate);
        }
        catch (InvalidDeliveryReceiptException e) {
            Assert.fail((String)("Failed parsing delivery receipt:" + e.getMessage()));
        }
    }

    @Test
    public void parseWithNoTextAttribute() {
        try {
            DeliveryReceipt delReceipt = this.decomposer.deliveryReceipt("id:0123456789 sub:001 dlvrd:001 submit date:0809011130 done date:0809011131 stat:DELIVRD err:000 testing jsmpp bow");
            Assert.assertEquals((String)delReceipt.getText(), null);
            Date submitDate = delReceipt.getSubmitDate();
            Date expectedSubmitDate = DeliveryReceiptParserTest.createDate(2008, 9, 1, 11, 30);
            Assert.assertEquals((Object)submitDate, (Object)expectedSubmitDate);
            Date doneDate = delReceipt.getDoneDate();
            Date expectedDoneDate = DeliveryReceiptParserTest.createDate(2008, 9, 1, 11, 31);
            Assert.assertEquals((Object)doneDate, (Object)expectedDoneDate);
        }
        catch (InvalidDeliveryReceiptException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed parsing delivery receipt:" + e.getMessage()));
        }
    }

    private static Date createDate(int year, int month, int day, int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

