/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.util.PDUByteBuffer;
import org.jsmpp.util.SimpleCapacityPolicy;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PDUByteBufferTest {
    private static final int BYTE_LENGTH = 1;
    private static final int INTEGER_LENGTH = 4;
    private static final int INITIAL_LENGTH = 4;
    private PDUByteBuffer byteBuffer;

    @BeforeMethod
    public void setUp() {
        this.byteBuffer = new PDUByteBuffer(new SimpleCapacityPolicy());
    }

    @Test(groups={"checkintest"})
    public void initialLengthValidity() {
        byte[] pdu = this.byteBuffer.toBytes();
        Assert.assertEquals((int)pdu.length, (int)4);
        Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getCommandLengthValue());
        Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getBytesLength());
    }

    @Test(groups={"checkintest"}, dependsOnMethods={"initialLengthValidity"})
    public void testLengthValidityForIntAppends() {
        int i = 0;
        while (i < 5) {
            this.byteBuffer.append(10);
            byte[] pdu = this.byteBuffer.toBytes();
            Assert.assertEquals((int)pdu.length, (int)(4 + 4 * (i + 1)), (String)("Failed on iteration " + i));
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getCommandLengthValue());
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getBytesLength());
            ++i;
        }
    }

    @Test(groups={"checkintest"}, dependsOnMethods={"initialLengthValidity"})
    public void testLengthValidityForByteAppends() {
        int i = 0;
        while (i < 5) {
            this.byteBuffer.append((byte)10);
            byte[] pdu = this.byteBuffer.toBytes();
            Assert.assertEquals((int)pdu.length, (int)(4 + 1 * (i + 1)), (String)("Failed on iteration " + i));
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getCommandLengthValue(), (String)("Failed on iteration " + i));
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getBytesLength(), (String)("Failed on iteration " + i));
            ++i;
        }
    }

    @Test(groups={"checkintest"}, dependsOnMethods={"initialLengthValidity"})
    public void testLengthValidityForCString() {
        String hello = "PDUByteBuffer integration test for JSMPP API";
        int i = 0;
        while (i < 5) {
            this.byteBuffer.append(hello);
            byte[] pdu = this.byteBuffer.toBytes();
            Assert.assertEquals((int)pdu.length, (int)(4 + hello.length() * (i + 1) + (i + 1)), (String)("Failed on iteration " + i));
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getCommandLengthValue(), (String)("Failed on iteration " + i));
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getBytesLength(), (String)("Failed on iteration " + i));
            ++i;
        }
    }

    @Test(groups={"checkintest"}, dependsOnMethods={"initialLengthValidity"})
    public void testLengthValidityForString() {
        String hello = "PDUByteBuffer integration test for JSMPP API";
        int i = 0;
        while (i < 5) {
            this.byteBuffer.append(hello, false);
            byte[] pdu = this.byteBuffer.toBytes();
            Assert.assertEquals((int)pdu.length, (int)(4 + hello.length() * (i + 1)), (String)("Failed on iteration " + i));
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getCommandLengthValue(), (String)("Failed on iteration " + i));
            Assert.assertEquals((int)pdu.length, (int)this.byteBuffer.getBytesLength(), (String)("Failed on iteration " + i));
            ++i;
        }
    }
}

