/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.PDUStringException;
import org.jsmpp.util.StringParameter;
import org.jsmpp.util.StringType;

public final class StringValidator {
    private StringValidator() {
    }

    public static void validateString(String value, StringParameter param) throws PDUStringException {
        if (param.getType() == StringType.C_OCTEC_STRING) {
            if (param.isRangeMinAndMax()) {
                if (!StringValidator.isCOctetStringValid(value, param.getMax())) {
                    throw new PDUStringException("C-Octet String value '" + value + "' cannot more than " + param.getMax() + ". Actual length of string is " + value.length(), param);
                }
            } else if (!StringValidator.isCOctetStringNullOrNValValid(value, param.getMax())) {
                throw new PDUStringException("C-Octet String value should be 1 or " + param.getMax() + ". The actual length of string is " + value.length(), param);
            }
        } else if (param.getType() == StringType.OCTET_STRING && !StringValidator.isOctetStringValid(value, param.getMax())) {
            throw new PDUStringException("Octet String value '" + value + "' cannot more than " + param.getMax() + ". Actual length of string is " + value.length(), param);
        }
    }

    public static void validateString(byte[] value, StringParameter param) throws PDUStringException {
        if (param.getType() == StringType.C_OCTEC_STRING) {
            if (param.isRangeMinAndMax()) {
                if (!StringValidator.isCOctetStringValid(value, param.getMax())) {
                    throw new PDUStringException("C-Octet String value '" + new String(value) + "' cannot more than " + param.getMax() + ". Actual length of string is " + value.length, param);
                }
            } else if (!StringValidator.isCOctetStringNullOrNValValid(value, param.getMax())) {
                throw new PDUStringException("C-Octet String value should be 1 or " + param.getMax() + ". The actual length of string is " + value.length, param);
            }
        } else if (param.getType() == StringType.OCTET_STRING && !StringValidator.isOctetStringValid(value, param.getMax())) {
            throw new PDUStringException("Octet String value '" + new String(value) + "' cannot more than " + param.getMax() + ". Actual length of string is " + value.length, param);
        }
    }

    static boolean isCOctetStringValid(String value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length() < maxLength;
    }

    static boolean isCOctetStringValid(byte[] value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length < maxLength;
    }

    static boolean isCOctetStringNullOrNValValid(String value, int length) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0) {
            return true;
        }
        return value.length() == length - 1;
    }

    static boolean isCOctetStringNullOrNValValid(byte[] value, int length) {
        if (value == null) {
            return true;
        }
        if (value.length == 0) {
            return true;
        }
        return value.length == length;
    }

    static boolean isOctetStringValid(String value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length() <= maxLength;
    }

    static boolean isOctetStringValid(byte[] value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length <= maxLength;
    }
}

