/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.xbean.naming.context.AbstractFederatedContext;
import org.apache.xbean.naming.context.ContextAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableFederatedContext
extends AbstractFederatedContext {
    public ImmutableFederatedContext(String nameInNamespace, Set<Context> federatedContexts) {
        super(nameInNamespace, ContextAccess.UNMODIFIABLE, federatedContexts);
    }

    public void federateContext(Context context) throws NamingException {
        ImmutableFederatedContext.addFederatedContext(this, context);
    }

    public void unfederateContext(Context context) throws NamingException {
        ImmutableFederatedContext.removeFederatedContext(this, context);
    }

    @Override
    protected Map<String, Object> getWrapperBindings() throws NamingException {
        return Collections.emptyMap();
    }

    @Override
    public Context createNestedSubcontext(String path, Map<String, Object> bindings) throws NamingException {
        return new NestedImmutableFederatedContext(path, bindings);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NestedImmutableFederatedContext
    extends AbstractFederatedContext {
        private final AtomicReference<Map<String, Object>> bindingsRef;
        private final String pathWithSlash;

        public NestedImmutableFederatedContext(String path, Map<String, Object> bindings) throws NamingException {
            super(ImmutableFederatedContext.this, path);
            path = this.getNameInNamespace();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.pathWithSlash = path;
            this.bindingsRef = new AtomicReference<Map<String, Object>>(Collections.unmodifiableMap(bindings));
        }

        @Override
        public Context createNestedSubcontext(String path, Map<String, Object> bindings) throws NamingException {
            return new NestedImmutableFederatedContext(this.getNameInNamespace(path), bindings);
        }

        @Override
        protected Object getDeepBinding(String name) {
            String absoluteName = this.pathWithSlash + name;
            return ImmutableFederatedContext.this.getDeepBinding(absoluteName);
        }

        @Override
        protected Map<String, Object> getWrapperBindings() throws NamingException {
            return this.bindingsRef.get();
        }

        @Override
        protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
            throw new OperationNotSupportedException("Context is immutable");
        }

        @Override
        protected boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
            throw new OperationNotSupportedException("Context is immutable");
        }
    }
}

