/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.util.Date;
import java.util.Random;

public class MemoryUsage {
    public void updateMemoryUsage(XScriptContext xScriptContext) throws Exception {
        XSpreadsheet xSpreadsheet = this.createSpreadsheet(xScriptContext);
        Runtime runtime = Runtime.getRuntime();
        Random random = new Random();
        Date date = new Date();
        int n = (int)(random.nextFloat() * (float)runtime.freeMemory() / 5.0f);
        byte[] byArray = new byte[n];
        this.addData(xSpreadsheet, date.toString(), runtime.totalMemory(), runtime.freeMemory());
        this.addChart(xSpreadsheet);
    }

    private XSpreadsheet createSpreadsheet(XScriptContext xScriptContext) throws Exception {
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xScriptContext.getDesktop());
        XComponent xComponent = xComponentLoader.loadComponentFromURL("private:factory/scalc", "_blank", 4, new PropertyValue[0]);
        XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheetDocument.getSheets());
        XSpreadsheet xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(0));
        return xSpreadsheet;
    }

    private void addData(XSpreadsheet xSpreadsheet, String string, long l, long l2) throws Exception {
        xSpreadsheet.getCellByPosition(0, 0).setFormula("Used");
        xSpreadsheet.getCellByPosition(0, 1).setFormula("Free");
        xSpreadsheet.getCellByPosition(0, 2).setFormula("Total");
        xSpreadsheet.getCellByPosition(1, 0).setValue((double)(l - l2));
        xSpreadsheet.getCellByPosition(1, 1).setValue((double)l2);
        xSpreadsheet.getCellByPosition(1, 2).setValue((double)l);
    }

    private void addChart(XSpreadsheet xSpreadsheet) throws Exception {
        Rectangle rectangle = new Rectangle();
        rectangle.X = 500;
        rectangle.Y = 3000;
        rectangle.Width = 10000;
        rectangle.Height = 8000;
        XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)xSpreadsheet);
        XCellRange xCellRange2 = xCellRange.getCellRangeByName("A1:B2");
        XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)xCellRange2);
        CellRangeAddress cellRangeAddress = xCellRangeAddressable.getRangeAddress();
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[]{cellRangeAddress};
        XTableChartsSupplier xTableChartsSupplier = (XTableChartsSupplier)UnoRuntime.queryInterface(XTableChartsSupplier.class, (Object)xSpreadsheet);
        XTableCharts xTableCharts = xTableChartsSupplier.getCharts();
        xTableCharts.addNewByName("Example", rectangle, cellRangeAddressArray, false, true);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xTableCharts);
        XTableChart xTableChart = (XTableChart)UnoRuntime.queryInterface(XTableChart.class, (Object)xNameAccess.getByName("Example"));
        XEmbeddedObjectSupplier xEmbeddedObjectSupplier = (XEmbeddedObjectSupplier)UnoRuntime.queryInterface(XEmbeddedObjectSupplier.class, (Object)xTableChart);
        XComponent xComponent = xEmbeddedObjectSupplier.getEmbeddedObject();
        XChartDocument xChartDocument = (XChartDocument)UnoRuntime.queryInterface(XChartDocument.class, (Object)xComponent);
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xChartDocument);
        Object object = xMultiServiceFactory.createInstance("com.sun.star.chart.PieDiagram");
        XDiagram xDiagram = (XDiagram)UnoRuntime.queryInterface(XDiagram.class, (Object)object);
        xChartDocument.setDiagram(xDiagram);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xChartDocument.getTitle());
        xPropertySet.setPropertyValue("String", (Object)"JVM Memory Usage");
    }
}

