/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Fonts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AllFonts
extends AnimatingControlsSurface {
    private static Vector<Font> fonts = new Vector();
    private int nStrs;
    private int strH;
    private int fi;
    protected int fsize = 14;
    protected Vector<Font> v = new Vector();

    public AllFonts() {
        this.setBackground(Color.WHITE);
        this.setSleepAmount(500L);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void handleThread(int n) {
    }

    public void reset(int n, int n2) {
        this.v.clear();
        Font font = fonts.get(0).deriveFont(0, this.fsize);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.strH = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.nStrs = n2 / this.strH + 1;
        this.fi = 0;
    }

    public void step(int n, int n2) {
        if (this.fi < fonts.size()) {
            this.v.addElement(fonts.get(this.fi).deriveFont(0, this.fsize));
        }
        if (this.v.size() == this.nStrs && this.v.size() != 0 || this.fi > fonts.size()) {
            this.v.removeElementAt(0);
        }
        this.fi = this.v.size() == 0 ? 0 : (this.fi = this.fi + 1);
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setColor(Color.BLACK);
        int n3 = this.fi >= fonts.size() ? 0 : n2 - this.v.size() * this.strH - this.strH / 2;
        for (int i = 0; i < this.v.size(); ++i) {
            Font font = this.v.get(i);
            int n4 = this.getFontMetrics(font).stringWidth(font.getName());
            graphics2D.setFont(font);
            graphics2D.drawString(font.getName(), n / 2 - n4 / 2, n3 += this.strH);
        }
    }

    public static void main(String[] stringArray) {
        AllFonts.createDemoFrame(new AllFonts());
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : graphicsEnvironment.getAllFonts()) {
            if (font.canDisplayUpTo(font.getName()) == 0) continue;
            fonts.addElement(font);
        }
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener,
    ChangeListener {
        AllFonts demo;
        JSlider slider;
        int[] fsize = new int[]{8, 14, 18, 24};
        JMenuItem[] menuitem = new JMenuItem[this.fsize.length];
        Font[] font = new Font[this.fsize.length];

        public DemoControls(AllFonts allFonts) {
            this.demo = allFonts;
            this.setBackground(Color.GRAY);
            int n = (int)allFonts.getSleepAmount();
            this.slider = new JSlider(0, 0, 999, n);
            this.slider.setBorder(new EtchedBorder());
            this.slider.setPreferredSize(new Dimension(90, 22));
            this.slider.addChangeListener(this);
            this.add(this.slider);
            JMenuBar jMenuBar = new JMenuBar();
            this.add(jMenuBar);
            JMenu jMenu = jMenuBar.add(new JMenu("Font Size"));
            for (int i = 0; i < this.fsize.length; ++i) {
                this.font[i] = new Font("serif", 0, this.fsize[i]);
                this.menuitem[i] = jMenu.add(new JMenuItem(String.valueOf(this.fsize[i])));
                this.menuitem[i].setFont(this.font[i]);
                this.menuitem[i].addActionListener(this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < this.fsize.length; ++i) {
                if (!actionEvent.getSource().equals(this.menuitem[i])) continue;
                this.demo.fsize = this.fsize[i];
                Dimension dimension = this.demo.getSize();
                this.demo.reset(dimension.width, dimension.height);
                break;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.demo.setSleepAmount(this.slider.getValue());
        }
    }
}

