/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.progress.spi.RunOffEDTProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ProgressUtils {
    private static final RunOffEDTProvider PROVIDER = ProgressUtils.getProvider();
    private static final int DISPLAY_DIALOG_MS = 9450;
    private static final int DISPLAY_WAIT_CURSOR_MS = 50;

    private ProgressUtils() {
    }

    private static RunOffEDTProvider getProvider() {
        RunOffEDTProvider runOffEDTProvider = (RunOffEDTProvider)Lookup.getDefault().lookup(RunOffEDTProvider.class);
        return runOffEDTProvider != null ? runOffEDTProvider : new Trivial();
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl) {
        PROVIDER.runOffEventDispatchThread(runnable, string, atomicBoolean, bl, 50, 9450);
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        PROVIDER.runOffEventDispatchThread(runnable, string, atomicBoolean, bl, n, n2);
    }

    private static class Trivial
    implements RunOffEDTProvider {
        private static final RequestProcessor WORKER = new RequestProcessor(ProgressUtils.class.getName());

        private Trivial() {
        }

        public void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.Task task = WORKER.post(runnable);
                task.waitFinished();
            } else {
                runnable.run();
            }
        }
    }
}

