/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.sparc.SPARCFormat3AInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

public class SPARCSaveInstruction
extends SPARCFormat3AInstruction {
    private final boolean trivial;

    public SPARCSaveInstruction(SPARCRegister rs1, ImmediateOrRegister operand2, SPARCRegister rd) {
        super("save", 60, rs1, operand2, rd);
        SPARCRegister G0 = SPARCRegisters.G0;
        this.trivial = rs1 == G0 && operand2 == G0 && rd == G0;
    }

    public boolean isTrivial() {
        return this.trivial;
    }

    protected String getOperand2String() {
        StringBuffer buf = new StringBuffer();
        if (this.operand2.isRegister()) {
            buf.append(this.operand2.toString());
        } else {
            Number number = ((Immediate)this.operand2).getNumber();
            int value = number.intValue();
            if (value < 0) {
                buf.append("-0x");
                value = -value;
            } else {
                buf.append("0x");
            }
            buf.append(Integer.toHexString(value));
        }
        return buf.toString();
    }

    protected String getDescription() {
        return this.trivial ? this.getName() : super.getDescription();
    }
}

