/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.PCDesc;
import sun.jvm.hotspot.code.ScopeDesc;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.JByteField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class NMethod
extends CodeBlob {
    private static long pcDescSize;
    private static CIntegerField zombieInstructionSizeField;
    private static OopField methodField;
    private static CIntegerField entryBCIField;
    private static AddressField osrLinkField;
    private static AddressField scavengeRootLinkField;
    private static JByteField scavengeRootStateField;
    private static CIntegerField exceptionOffsetField;
    private static CIntegerField deoptOffsetField;
    private static CIntegerField origPCOffsetField;
    private static CIntegerField stubOffsetField;
    private static CIntegerField scopesDataOffsetField;
    private static CIntegerField scopesPCsOffsetField;
    private static CIntegerField dependenciesOffsetField;
    private static CIntegerField handlerTableOffsetField;
    private static CIntegerField nulChkTableOffsetField;
    private static CIntegerField nmethodEndOffsetField;
    private static AddressField entryPointField;
    private static AddressField verifiedEntryPointField;
    private static AddressField osrEntryPointField;
    private static JIntField lockCountField;
    private static CIntegerField stackTraversalMarkField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("nmethod");
        zombieInstructionSizeField = type.getCIntegerField("_zombie_instruction_size");
        methodField = type.getOopField("_method");
        entryBCIField = type.getCIntegerField("_entry_bci");
        osrLinkField = type.getAddressField("_osr_link");
        scavengeRootLinkField = type.getAddressField("_scavenge_root_link");
        scavengeRootStateField = type.getJByteField("_scavenge_root_state");
        exceptionOffsetField = type.getCIntegerField("_exception_offset");
        deoptOffsetField = type.getCIntegerField("_deoptimize_offset");
        origPCOffsetField = type.getCIntegerField("_orig_pc_offset");
        stubOffsetField = type.getCIntegerField("_stub_offset");
        scopesDataOffsetField = type.getCIntegerField("_scopes_data_offset");
        scopesPCsOffsetField = type.getCIntegerField("_scopes_pcs_offset");
        dependenciesOffsetField = type.getCIntegerField("_dependencies_offset");
        handlerTableOffsetField = type.getCIntegerField("_handler_table_offset");
        nulChkTableOffsetField = type.getCIntegerField("_nul_chk_table_offset");
        nmethodEndOffsetField = type.getCIntegerField("_nmethod_end_offset");
        entryPointField = type.getAddressField("_entry_point");
        verifiedEntryPointField = type.getAddressField("_verified_entry_point");
        osrEntryPointField = type.getAddressField("_osr_entry_point");
        lockCountField = type.getJIntField("_lock_count");
        stackTraversalMarkField = type.getCIntegerField("_stack_traversal_mark");
        pcDescSize = db.lookupType("PcDesc").getSize();
    }

    public NMethod(Address addr) {
        super(addr);
    }

    public Address getAddress() {
        return this.addr;
    }

    public Method getMethod() {
        return (Method)VM.getVM().getObjectHeap().newOop(methodField.getValue(this.addr));
    }

    public boolean isNMethod() {
        return true;
    }

    public boolean isJavaMethod() {
        return !this.getMethod().isNative();
    }

    public boolean isNativeMethod() {
        return this.getMethod().isNative();
    }

    public boolean isOSRMethod() {
        return this.getEntryBCI() != VM.getVM().getInvocationEntryBCI();
    }

    public Address constantsBegin() {
        return this.instructionsBegin();
    }

    public Address constantsEnd() {
        return this.getEntryPoint();
    }

    public Address codeBegin() {
        return this.getEntryPoint();
    }

    public Address codeEnd() {
        return this.headerBegin().addOffsetTo(this.getStubOffset());
    }

    public Address exceptionBegin() {
        return this.headerBegin().addOffsetTo(this.getExceptionOffset());
    }

    public Address deoptBegin() {
        return this.headerBegin().addOffsetTo(this.getDeoptOffset());
    }

    public Address stubBegin() {
        return this.headerBegin().addOffsetTo(this.getStubOffset());
    }

    public Address stubEnd() {
        return this.headerBegin().addOffsetTo(this.getScopesDataOffset());
    }

    public Address scopesDataBegin() {
        return this.headerBegin().addOffsetTo(this.getScopesDataOffset());
    }

    public Address scopesDataEnd() {
        return this.headerBegin().addOffsetTo(this.getScopesPCsOffset());
    }

    public Address scopesPCsBegin() {
        return this.headerBegin().addOffsetTo(this.getScopesPCsOffset());
    }

    public Address scopesPCsEnd() {
        return this.headerBegin().addOffsetTo(this.getDependenciesOffset());
    }

    public Address dependenciesBegin() {
        return this.headerBegin().addOffsetTo(this.getDependenciesOffset());
    }

    public Address dependenciesEnd() {
        return this.headerBegin().addOffsetTo(this.getHandlerTableOffset());
    }

    public Address handlerTableBegin() {
        return this.headerBegin().addOffsetTo(this.getHandlerTableOffset());
    }

    public Address handlerTableEnd() {
        return this.headerBegin().addOffsetTo(this.getNulChkTableOffset());
    }

    public Address nulChkTableBegin() {
        return this.headerBegin().addOffsetTo(this.getNulChkTableOffset());
    }

    public Address nulChkTableEnd() {
        return this.headerBegin().addOffsetTo(this.getNMethodEndOffset());
    }

    public int constantsSize() {
        return (int)this.constantsEnd().minus(this.constantsBegin());
    }

    public int codeSize() {
        return (int)this.codeEnd().minus(this.codeBegin());
    }

    public int stubSize() {
        return (int)this.stubEnd().minus(this.stubBegin());
    }

    public int scopesDataSize() {
        return (int)this.scopesDataEnd().minus(this.scopesDataBegin());
    }

    public int scopesPCsSize() {
        return (int)this.scopesPCsEnd().minus(this.scopesPCsBegin());
    }

    public int dependenciesSize() {
        return (int)this.dependenciesEnd().minus(this.dependenciesBegin());
    }

    public int handlerTableSize() {
        return (int)this.handlerTableEnd().minus(this.handlerTableBegin());
    }

    public int nulChkTableSize() {
        return (int)this.nulChkTableEnd().minus(this.nulChkTableBegin());
    }

    public int origPCOffset() {
        return (int)origPCOffsetField.getValue(this.addr);
    }

    public int totalSize() {
        return this.constantsSize() + this.codeSize() + this.stubSize() + this.scopesDataSize() + this.scopesPCsSize() + this.dependenciesSize() + this.handlerTableSize() + this.nulChkTableSize();
    }

    public boolean constantsContains(Address addr) {
        return this.constantsBegin().lessThanOrEqual(addr) && this.constantsEnd().greaterThan(addr);
    }

    public boolean codeContains(Address addr) {
        return this.codeBegin().lessThanOrEqual(addr) && this.codeEnd().greaterThan(addr);
    }

    public boolean stubContains(Address addr) {
        return this.stubBegin().lessThanOrEqual(addr) && this.stubEnd().greaterThan(addr);
    }

    public boolean scopesDataContains(Address addr) {
        return this.scopesDataBegin().lessThanOrEqual(addr) && this.scopesDataEnd().greaterThan(addr);
    }

    public boolean scopesPCsContains(Address addr) {
        return this.scopesPCsBegin().lessThanOrEqual(addr) && this.scopesPCsEnd().greaterThan(addr);
    }

    public boolean handlerTableContains(Address addr) {
        return this.handlerTableBegin().lessThanOrEqual(addr) && this.handlerTableEnd().greaterThan(addr);
    }

    public boolean nulChkTableContains(Address addr) {
        return this.nulChkTableBegin().lessThanOrEqual(addr) && this.nulChkTableEnd().greaterThan(addr);
    }

    public Address getEntryPoint() {
        return entryPointField.getValue(this.addr);
    }

    public Address getVerifiedEntryPoint() {
        return verifiedEntryPointField.getValue(this.addr);
    }

    public boolean isZombie() {
        return false;
    }

    public int getOSREntryBCI() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getEntryBCI() != VM.getVM().getInvocationEntryBCI(), "wrong kind of nmethod");
        }
        return this.getEntryBCI();
    }

    public NMethod getOSRLink() {
        return (NMethod)VMObjectFactory.newObject(NMethod.class, osrLinkField.getValue(this.addr));
    }

    public NMethod getScavengeRootLink() {
        return (NMethod)VMObjectFactory.newObject(NMethod.class, scavengeRootLinkField.getValue(this.addr));
    }

    public int getScavengeRootState() {
        return scavengeRootStateField.getValue(this.addr);
    }

    public boolean canBeDeoptimized() {
        return this.isJavaMethod();
    }

    public boolean isLockedByVM() {
        return lockCountField.getValue(this.addr) > 0;
    }

    public PCDesc getPCDescAt(Address pc) {
        Address p = this.scopesPCsBegin();
        while (p.lessThan(this.scopesPCsEnd())) {
            PCDesc pcDesc = new PCDesc(p);
            if (((Object)pcDesc.getRealPC(this)).equals(pc)) {
                return pcDesc;
            }
            p = p.addOffsetTo(pcDescSize);
        }
        return null;
    }

    public ScopeDesc getScopeDescAt(Address pc) {
        PCDesc pd = this.getPCDescAt(pc);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(pd != null, "scope must be present");
        }
        return new ScopeDesc(this, pd.getScopeDecodeOffset(), pd.getObjDecodeOffset(), pd.getReexecute());
    }

    public PCDesc getPCDescNearDbg(Address pc) {
        PCDesc bestGuessPCDesc = null;
        long bestDistance = 0L;
        Address p = this.scopesPCsBegin();
        while (p.lessThan(this.scopesPCsEnd())) {
            PCDesc pcDesc = new PCDesc(p);
            long distance = -pcDesc.getRealPC(this).minus(pc);
            if (bestGuessPCDesc == null || distance >= 0L && distance < bestDistance) {
                bestGuessPCDesc = pcDesc;
                bestDistance = distance;
            }
            p = p.addOffsetTo(pcDescSize);
        }
        return bestGuessPCDesc;
    }

    public ScopeDesc getScopeDescNearDbg(Address pc) {
        PCDesc pd = this.getPCDescNearDbg(pc);
        if (pd == null) {
            return null;
        }
        return new ScopeDesc(this, pd.getScopeDecodeOffset(), pd.getObjDecodeOffset(), pd.getReexecute());
    }

    public Map getSafepoints() {
        HashMap<Address, PCDesc> safepoints = new HashMap<Address, PCDesc>();
        Address p = null;
        p = this.scopesPCsBegin();
        while (p.lessThan(this.scopesPCsEnd())) {
            PCDesc pcDesc = new PCDesc(p);
            Address pc = pcDesc.getRealPC(this);
            safepoints.put(pc, pcDesc);
            p = p.addOffsetTo(pcDescSize);
        }
        return safepoints;
    }

    public static int getEntryPointOffset() {
        return (int)entryPointField.getOffset();
    }

    public static int getVerifiedEntryPointOffset() {
        return (int)verifiedEntryPointField.getOffset();
    }

    public static int getOSREntryPointOffset() {
        return (int)osrEntryPointField.getOffset();
    }

    public static int getEntryBCIOffset() {
        return (int)entryBCIField.getOffset();
    }

    public static int getMethodOffset() {
        return (int)methodField.getOffset();
    }

    public void print() {
        this.printOn(System.out);
    }

    public String toString() {
        Method method = this.getMethod();
        return "NMethod for " + method.getMethodHolder().getName().asString() + "." + method.getName().asString() + method.getSignature().asString() + "==>n" + super.toString();
    }

    public String flagsToString() {
        return "";
    }

    public String getName() {
        Method method = this.getMethod();
        return "NMethod for " + method.getMethodHolder().getName().asString() + "." + method.getName().asString() + method.getSignature().asString();
    }

    private int getEntryBCI() {
        return (int)entryBCIField.getValue(this.addr);
    }

    private int getExceptionOffset() {
        return (int)exceptionOffsetField.getValue(this.addr);
    }

    private int getDeoptOffset() {
        return (int)deoptOffsetField.getValue(this.addr);
    }

    private int getStubOffset() {
        return (int)stubOffsetField.getValue(this.addr);
    }

    private int getScopesDataOffset() {
        return (int)scopesDataOffsetField.getValue(this.addr);
    }

    private int getScopesPCsOffset() {
        return (int)scopesPCsOffsetField.getValue(this.addr);
    }

    private int getDependenciesOffset() {
        return (int)dependenciesOffsetField.getValue(this.addr);
    }

    private int getHandlerTableOffset() {
        return (int)handlerTableOffsetField.getValue(this.addr);
    }

    private int getNulChkTableOffset() {
        return (int)nulChkTableOffsetField.getValue(this.addr);
    }

    private int getNMethodEndOffset() {
        return (int)nmethodEndOffsetField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                NMethod.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

