/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.amd64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;

public final class LinuxAMD64CFrame
extends BasicCFrame {
    private static final int ADDRESS_SIZE = 8;
    private Address rip;
    private Address rbp;
    private LinuxDebugger dbg;

    public LinuxAMD64CFrame(LinuxDebugger dbg, Address rbp, Address rip) {
        super(dbg.getCDebugger());
        this.rbp = rbp;
        this.rip = rip;
        this.dbg = dbg;
    }

    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    public Address pc() {
        return this.rip;
    }

    public Address localVariableBase() {
        return this.rbp;
    }

    public CFrame sender() {
        if (this.rbp == null) {
            return null;
        }
        Address nextRBP = this.rbp.getAddressAt(0L);
        if (nextRBP == null) {
            return null;
        }
        Address nextPC = this.rbp.getAddressAt(8L);
        if (nextPC == null) {
            return null;
        }
        return new LinuxAMD64CFrame(this.dbg, nextRBP, nextPC);
    }
}

