/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWithKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeMultiANewArray
extends BytecodeWithKlass {
    BytecodeMultiANewArray(Method method, int bci) {
        super(method, bci);
    }

    public Klass getKlass() {
        return super.getKlass();
    }

    public int getDimension() {
        return 0xFF & this.javaByteAt(2);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check multianewarray");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 197;
    }

    public static BytecodeMultiANewArray at(Method method, int bci) {
        BytecodeMultiANewArray b = new BytecodeMultiANewArray(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeMultiANewArray atCheck(Method method, int bci) {
        BytecodeMultiANewArray b = new BytecodeMultiANewArray(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeMultiANewArray at(BytecodeStream bcs) {
        return new BytecodeMultiANewArray(bcs.method(), bcs.bci());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(" ");
        buf.append(Integer.toString(this.getDimension()));
        return buf.toString();
    }
}

